package de.mklinger.qetcher.liferay.client.impl;

import aQute.bnd.annotation.metatype.Meta;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */

/**
 * CA certificate configuration for Qetcher.
 *
 * To override the defaults, create the file
 *
 * liferay/osgi/configs/de.mklinger.qetcher.liferay.client.impl.QetcherCaCertConfiguration.cfg
 *
 * and set properties named like the methods in this interface.
 *
 * This configuration is not available via UI, changing the defaults is only
 * required for test setups that use self-signed certificates.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
@Meta.OCD(
		id = QetcherTrustStoreConfiguration.ID)
public interface QetcherTrustStoreConfiguration {
	String ID = "de.mklinger.qetcher.liferay.client.impl.QetcherTrustStoreConfiguration";

	String DEFAULT_TYPE = "pem";
	String DEFAULT_LOCATION = "classpath:mklinger-ca-cert.pem";
	String DEFAULT_PASSWORD = "";

	@Meta.AD(deflt = DEFAULT_TYPE,
			required = false)
	String trustStoreType();

	@Meta.AD(deflt = DEFAULT_LOCATION,
			required = false)
	String trustStoreLocation();

	@Meta.AD(deflt = DEFAULT_PASSWORD,
			required = false)
	String trustStorePassword();
}
