package de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;

import de.mklinger.qetcher.liferay.abstraction.PortalTool;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class PortalToolImpl implements PortalTool {
	private static final Logger LOG = LoggerFactory.getLogger(PortalToolImpl.class);

	@Override
	public String getBaseUrl() {
		final ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
		if (serviceContext != null) {
			String baseUrl = serviceContext.getLayoutFullURL();
			if (baseUrl != null) {
				LOG.debug("Have layout full url: {}", baseUrl);
				return baseUrl;
			}
			baseUrl = serviceContext.getPortalURL();
			if (baseUrl != null) {
				LOG.debug("Have portal url: {}", baseUrl);
				return baseUrl;
			}
		}

		//PortalSessionThreadLocal
		//PrincipalThreadLocal

		final Long companyId = CompanyThreadLocal.getCompanyId();
		if (companyId != null) {
			Company company;
			try {
				company = CompanyLocalServiceUtil.getCompany(companyId);
			} catch (PortalException | SystemException e) {
				return null;
			}
			final String baseUrl = "http://" + company.getVirtualHostname();
			LOG.debug("Have company virtual host url: {}", baseUrl);
			return baseUrl;
		}

		return null;
	}

	@Override
	public HttpServletRequest getHttpServletRequest() {
		final ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
		if (serviceContext == null) {
			return null;
		}
		return serviceContext.getRequest();
	}
}
