package de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71;

import de.mklinger.qetcher.liferay.abstraction.CacheTool;
import de.mklinger.qetcher.liferay.abstraction.DLTool;
import de.mklinger.qetcher.liferay.abstraction.ImageTool;
import de.mklinger.qetcher.liferay.abstraction.PortalTool;
import de.mklinger.qetcher.liferay.abstraction.PropsTool;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public abstract class LiferayAbstractionFactory {
	private static LiferayAbstractionFactory liferayAbstractionFactory = new LiferayAbstractionFactoryImpl();

	public static LiferayAbstractionFactory getInstance() {
		return liferayAbstractionFactory;
	}

	public abstract ImageTool getImageTool();
	public abstract PropsTool getPropsTool();
	public abstract DLTool getDLTool();
	public abstract PortalTool getPortalTool();
	public abstract CacheTool getCacheTool();

	public static void setInstance(final LiferayAbstractionFactory instance) {
		liferayAbstractionFactory = instance;
	}
}
