package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

import aQute.bnd.annotation.metatype.Meta;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */

/**
 * Qetcher configuration.
 *
 * To override the defaults, create the file
 *
 * liferay/osgi/configs/de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration.cfg
 *
 * and set properties named like the methods in this interface.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
@ExtendedObjectClassDefinition(category = "connectors")
@Meta.OCD(
		id = QetcherConfiguration.ID,
		localization = "content/Language",
		name = "qetcher-configuration-name")
public interface QetcherConfiguration {
	// Note: For Liferay UI integration to work, the id must match the full qualified class name of this interface.
	String ID = "de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration";

	@Meta.AD(deflt = "",
			description = "service-addresses-description",
			name = "service-addresses-name",
			required = true)
	String[] serviceAddresses();

	@Meta.AD(deflt = "",
			description = "key-store-location-description",
			name = "key-store-location-name",
			required = false)
	String keyStoreLocation();

	@Meta.AD(deflt = "PKCS12",
			description = "key-store-type-description",
			name = "key-store-type-name",
			required = false)
	String keyStoreType();

	@Meta.AD(deflt = "",
			description = "key-store-password-description",
			name = "key-store-password-name",
			required = false)
	String keyStorePassword();

	@Meta.AD(deflt = "",
			description = "key-password-description",
			name = "key-password-name",
			required = false)
	String keyPassword();
}
