package de.mklinger.qetcher.liferay.client.impl;

import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
@SuppressWarnings("unchecked")
public class DefunctQetcherClient implements QetcherClient {
	private final CompletableFuture<?> exceptionFuture;

	public DefunctQetcherClient(final String exceptionMessage) {
		this(new DefunctQetcherClientException(exceptionMessage));
	}

	public DefunctQetcherClient(final RuntimeException exception) {
		this.exceptionFuture = new CompletableFuture<>();
		this.exceptionFuture.completeExceptionally(exception);
	}

	@Override
	public CompletableFuture<ConversionFile> uploadFile(final InputConversionFile inputFile) {
		return (CompletableFuture<ConversionFile>) exceptionFuture;
	}

	@Override
	public CompletableFuture<ConversionFile> getFile(final String fileId) {
		return (CompletableFuture<ConversionFile>) exceptionFuture;
	}

	@Override
	public CompletableFuture<List<ConversionFile>> getFiles() {
		return (CompletableFuture<List<ConversionFile>>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Void> deleteFile(final String fileId) {
		return (CompletableFuture<Void>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Path> downloadAsFile(final String fileId, final Path file, final OpenOption... openOptions) {
		return (CompletableFuture<Path>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Job> createJob(final InputJob inputJob) {
		return (CompletableFuture<Job>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Job> getJob(final String jobId) {
		return (CompletableFuture<Job>) exceptionFuture;
	}

	@Override
	public CompletableFuture<List<Job>> getJobs() {
		return (CompletableFuture<List<Job>>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Void> deleteJob(final String jobId) {
		return (CompletableFuture<Void>) exceptionFuture;
	}

	@Override
	public CompletableFuture<List<AvailableConversion>> getAvailableConversions() {
		return (CompletableFuture<List<AvailableConversion>>) exceptionFuture;
	}

	@Override
	public CompletableFuture<List<AvailableNode>> getAvailableNodes() {
		return (CompletableFuture<List<AvailableNode>>) exceptionFuture;
	}

	@Override
	public CompletableFuture<ConversionFile> getFile(final ConversionFile file) {
		return (CompletableFuture<ConversionFile>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Void> deleteFile(final ConversionFile file) {
		return (CompletableFuture<Void>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Path> downloadAsFile(final String fileId, final Path file) {
		return (CompletableFuture<Path>) exceptionFuture;
	}

	@Override
	public CompletableFuture<File> downloadAsFile(final String fileId, final File file) {
		return (CompletableFuture<File>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Path> downloadAsTempFile(final String fileId) {
		return (CompletableFuture<Path>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Path> downloadAsTempFile(final String fileId, final Path dir) {
		return (CompletableFuture<Path>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Job> getJob(final Job job) {
		return (CompletableFuture<Job>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Void> deleteJob(final Job job) {
		return (CompletableFuture<Void>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Job> getJobDone(final Job job) {
		return (CompletableFuture<Job>) exceptionFuture;
	}

	@Override
	public CompletableFuture<Job> getJobDone(final String jobId) {
		return (CompletableFuture<Job>) exceptionFuture;
	}

	@Override
	public void close() {
	}

	private static class DefunctQetcherClientException extends RuntimeException {
		private static final long serialVersionUID = 1L;

		public DefunctQetcherClientException(final String message) {
			super(message);
		}
	}
}
