/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl.abstraction;

import de.mklinger.qetcher.liferay.abstraction.CacheTool;
import de.mklinger.qetcher.liferay.abstraction.DLTool;
import de.mklinger.qetcher.liferay.abstraction.ImageTool;
import de.mklinger.qetcher.liferay.abstraction.PortalTool;
import de.mklinger.qetcher.liferay.abstraction.PropsTool;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class LiferayAbstractionFactoryImpl implements LiferayAbstractionFactory {
	private static final ImageTool IMAGE_TOOL = new ImageToolImpl();
	private static final PropsTool PROPS_TOOL = new PropsToolImpl();
	private static final DLTool DL_TOOL = new DLToolImpl();
	private static final PortalTool PORTAL_TOOL = new PortalToolImpl();
	private static final CacheTool CACHE_TOOL = new CacheToolImpl();

	@Override
	public ImageTool getImageTool() {
		return IMAGE_TOOL;
	}

	@Override
	public PropsTool getPropsTool() {
		return PROPS_TOOL;
	}

	@Override
	public DLTool getDLTool() {
		return DL_TOOL;
	}

	@Override
	public PortalTool getPortalTool() {
		return PORTAL_TOOL;
	}

	@Override
	public CacheTool getCacheTool() {
		return CACHE_TOOL;
	}
}
