/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.io.IOException;
import java.io.OutputStream;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de - klingerm
 */
public class NonClosingOutputStream extends OutputStream {
	private final OutputStream delegate;

	public NonClosingOutputStream(final OutputStream delegate) {
		this.delegate = delegate;
	}

	@Override
	public void write(final int b) throws IOException {
		delegate.write(b);
	}

	@Override
	public void write(final byte[] b) throws IOException {
		delegate.write(b);
	}

	@Override
	public void write(final byte[] b, final int off, final int len) throws IOException {
		delegate.write(b, off, len);
	}

	@Override
	public void flush() throws IOException {
		delegate.flush();
	}

	@Override
	public void close() throws IOException {
		// do nothing.
	}
}
