package de.mklinger.qetcher.liferay.client.impl;

import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MimeTypesUtil;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class FileExtensionUtil {
	private static final Logger LOG = LoggerFactory.getLogger(FileExtensionUtil.class);

	public static String getExtension(final FileVersion fileVersion) {
		final String mimeTypeString = fileVersion.getMimeType();
		LOG.debug("Original source file mime type: {}", mimeTypeString);
		LOG.debug("Original source file extension: {}", fileVersion.getExtension());
		String sourceExtension;
		final Set<String> extensions = MimeTypesUtil.getExtensions(mimeTypeString);
		if (extensions != null && !extensions.isEmpty()) {
			sourceExtension = extensions.iterator().next();
		} else {
			sourceExtension = fileVersion.getExtension();
		}
		if (sourceExtension == null || sourceExtension.isEmpty()) {
			LOG.warn("Could not determine source file extension for file entry {}", fileVersion.getFileEntryId());
			return null;
		}
		return sourceExtension;
	}
}
