/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl.abstraction;

import java.io.IOException;
import java.io.InputStream;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ImageServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

import de.mklinger.qetcher.liferay.abstraction.Image;
import de.mklinger.qetcher.liferay.abstraction.ImageTool;
import de.mklinger.qetcher.liferay.abstraction.LiferayException;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ImageToolImpl implements ImageTool {
	@Override
	public Image newImage() {
		return new ImageImpl();
	}

	@Override
	public Image getImage(final InputStream in) throws LiferayException, IOException {
		return fromLiferayImage(ImageToolUtil.getImage(in));
	}

	@Override
	public Image getImage(final long imageId) throws LiferayException {
		try {
			return fromLiferayImage(ImageServiceUtil.getImage(imageId));
		} catch (PortalException | SystemException e) {
			throw new LiferayException(e);
		}
	}

	@Override
	public Image getDefaultCompanyLogo() {
		return fromLiferayImage(ImageToolUtil.getDefaultCompanyLogo());
	}

	@Override
	public Image getDefaultOrganizationLogo() {
		return fromLiferayImage(ImageToolUtil.getDefaultOrganizationLogo());
	}

	@Override
	public Image getDefaultUserFemalePortrait() {
		return fromLiferayImage(ImageToolUtil.getDefaultUserFemalePortrait());
	}

	@Override
	public Image getDefaultUserMalePortrait() {
		return fromLiferayImage(ImageToolUtil.getDefaultUserMalePortrait());
	}

	@Override
	public Image updateUserPortrait(final Image image, final long imageId) throws LiferayException {
		try {
			final User user = UserLocalServiceUtil.getUserByPortraitId(imageId);
			UserLocalServiceUtil.updatePortrait(user.getUserId(), image.getTextObj());
			return getImage(imageId);
		} catch (PortalException | SystemException e) {
			throw new LiferayException(e);
		}
	}

	private Image fromLiferayImage(final com.liferay.portal.model.Image liferayImage) {
		if (liferayImage == null) {
			return null;
		}
		return new LiferayImageWrapper(liferayImage);
	}
}
