/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.FileExtensionInfos;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypeInfo;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface QetcherLiferayService {
	List<AvailableConversion> getAvailableConversions();

	/**
	 * Convert method for DocumentConversionUtil.
	 */
	File convert(String id, InputStream inputStream, String sourceExtension, String targetExtension) throws IOException;

	/**
	 * Convert method for PDFProcessorImpl.
	 */
	void convert(InputStream inputStream, OutputStreamProvider outputStreamProvider,
			String sourceExtension, String targetExtension,
			Map<String, String> targetParameters, String jobReferer) throws IOException;

	/**
	 * Generic convert method.
	 */
	void convert(InputStream inputStream, OutputStream outputStream,
			String sourceExtension, String targetExtension,
			Map<String, String> targetParameters, String jobReferer) throws IOException;

	/**
	 * Generic convert method.
	 */
	void convert(final InputStream inputStream, final OutputStream outputStream,
			final MediaType fromMediaType, final MediaType toMediaType,
			final String jobReferer) throws IOException;

	String getFilePath(String id, String targetExtension);

	FileExtensionInfos getFileExtensions();

	Optional<MediaTypeInfo> getMediaTypeForFilename(String filename);

	List<MediaTypeInfo> getMediaTypes();
}
