/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.util.MimeTypesUtil;
import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.micro.keystores.KeyStores;
import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.QetcherClientBuilders;
import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.QetcherClientVersion;
import de.mklinger.qetcher.client.httpclient.BodyProviders;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.FileExtensionInfos;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypeInfo;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.htmlinliner.HtmlElementInliner;
import de.mklinger.qetcher.liferay.client.impl.LiferayClientConfiguration;
import de.mklinger.qetcher.liferay.client.impl.LiferayHtmlElementInlinerFactory;
import de.mklinger.qetcher.liferay.client.impl.NonClosingOutputStream;
import de.mklinger.qetcher.liferay.client.impl.OutputStreamProvider;
import de.mklinger.qetcher.liferay.client.impl.QetcherClientCertificateInfo;
import de.mklinger.qetcher.liferay.client.impl.QetcherLiferayService;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactorySupplier;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QetcherLiferayServiceImpl
implements QetcherLiferayService {
    private static final String APPLICATION_OCTETSTREAM = "application/octet-stream";
    private static final Logger LOG = LoggerFactory.getLogger(QetcherLiferayServiceImpl.class);
    private volatile QetcherClient qetcherClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QetcherClient client() {
        if (this.qetcherClient == null) {
            QetcherLiferayServiceImpl qetcherLiferayServiceImpl = this;
            synchronized (qetcherLiferayServiceImpl) {
                if (this.qetcherClient == null) {
                    this.qetcherClient = this.newClient();
                }
            }
        }
        return this.qetcherClient;
    }

    private QetcherClient newClient() {
        LiferayClientConfiguration configuration = LiferayClientConfiguration.getInstance();
        KeyStore keyStore = KeyStores.load((String)configuration.getKeyStoreLocation(), (String)configuration.getKeyStorePassword().orElse(null), (String)configuration.getKeyStoreType().orElse(KeyStore.getDefaultType()));
        KeyStore trustStore = KeyStores.load((String)configuration.getTrustStoreLocation(), (String)configuration.getTrustStorePassword().orElse(null), (String)configuration.getTrustStoreType().orElse(KeyStore.getDefaultType()));
        QetcherClient.Builder clientBuilder = QetcherClientBuilders.client().serviceAddresses(configuration.getServiceAddresses()).keyStore(keyStore, (String)configuration.getKeyPassword().orElse(null)).trustStore(trustStore);
        QetcherClient client = this.getWithContextClassLoader(this.getClass().getClassLoader(), () -> ((QetcherClient.Builder)clientBuilder).build());
        LOG.info("Initialized new Qetcher client, version {}", (Object)QetcherClientVersion.getVersion());
        LOG.info("Using Qetcher service addresses: {}", (Object)configuration.getServiceAddresses());
        new QetcherClientCertificateInfo(keyStore).log();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getWithContextClassLoader(ClassLoader classLoader, Supplier<T> s) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            LOG.info("Using thread context class loader: {}", (Object)classLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = s.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public List<AvailableConversion> getAvailableConversions() {
        try {
            return (List)QetcherLiferayServiceImpl.getWithShortTimeout(this.client().getAvailableConversions());
        }
        catch (Exception e) {
            LOG.error("Error getting available conversions from Qetcher service. Returning empty list.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static <T> T getWithShortTimeout(CompletableFuture<T> future) {
        return QetcherLiferayServiceImpl.get(future, 30L, TimeUnit.SECONDS);
    }

    private static <T> T getWithUploadTimeout(CompletableFuture<T> future) {
        return QetcherLiferayServiceImpl.get(future, 1L, TimeUnit.HOURS);
    }

    private static <T> T getWithDownloadTimeout(CompletableFuture<T> future) {
        return QetcherLiferayServiceImpl.get(future, 1L, TimeUnit.HOURS);
    }

    private static <T> T get(CompletableFuture<T> future, long timeout, TimeUnit timeoutUnit) {
        try {
            return future.get(timeout, timeoutUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new QetcherClientException("Qetcher client interrupted", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new QetcherClientException("Qetcher client timeout after " + timeout + " " + (Object)((Object)timeoutUnit), (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new QetcherClientException("Qetcher client error", (Throwable)e);
        }
    }

    @Override
    public File convert(String id, InputStream inputStream, String sourceExtension, String targetExtension) throws IOException {
        try {
            return this.doConvert(id, inputStream, sourceExtension, targetExtension, "liferay-conversion-id=" + id);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error converting file", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error converting file", (Throwable)e);
            throw new QetcherClientException("Error converting file", (Throwable)e);
        }
    }

    private File doConvert(String id, InputStream inputStream, String sourceExtension, String targetExtension, String jobReferer) throws IOException {
        File targetFile = new File(this.getFilePath(id, targetExtension));
        File targetDir = targetFile.getParentFile();
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IOException("Error creating target dir: " + targetDir);
        }
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            this.convert(inputStream, out, sourceExtension, targetExtension, null, jobReferer);
        }
        LOG.debug("Saved file to {}", (Object)targetFile);
        return targetFile;
    }

    @Override
    public void convert(InputStream inputStream, OutputStream outputStream, String sourceExtension, String targetExtension, Map<String, String> targetParameters, String jobReferer) {
        this.convert(inputStream, this.newSingleFileOutputStreamProvider(outputStream), sourceExtension, targetExtension, targetParameters, jobReferer);
    }

    @Override
    public void convert(InputStream inputStream, OutputStream outputStream, MediaType fromMediaType, MediaType toMediaType, String jobReferer) throws IOException {
        this.convert(inputStream, this.newSingleFileOutputStreamProvider(outputStream), fromMediaType, toMediaType, jobReferer);
    }

    private OutputStreamProvider newSingleFileOutputStreamProvider(final OutputStream outputStream) {
        return new OutputStreamProvider(){
            private boolean first = true;

            @Override
            public OutputStream getOutputStream(Job job, ConversionFile resultFile) {
                if (this.first) {
                    this.first = false;
                    return new NonClosingOutputStream(outputStream);
                }
                return null;
            }
        };
    }

    @Override
    public void convert(InputStream inputStream, OutputStreamProvider outputStreamProvider, String sourceExtension, String targetExtension, Map<String, String> targetParameters, String jobReferer) {
        this.doConvert(inputStream, sourceExtension, targetExtension, targetParameters, jobReferer, this.newSingleResultFileCallback(outputStreamProvider));
    }

    private void convert(InputStream inputStream, OutputStreamProvider outputStreamProvider, MediaType fromMediaType, MediaType toMediaType, String jobReferer) {
        this.doConvert(inputStream, fromMediaType, toMediaType, jobReferer, this.newSingleResultFileCallback(outputStreamProvider));
    }

    private ResultFileCallback newSingleResultFileCallback(final OutputStreamProvider outputStreamProvider) {
        return new ResultFileCallback(){

            @Override
            public void processResultFile(Job job, ConversionFile resultFile, QetcherClient client) {
                QetcherLiferayServiceImpl.this.handleResultFile(job, resultFile, outputStreamProvider, client);
            }
        };
    }

    private void handleResultFile(Job job, ConversionFile resultFile, OutputStreamProvider outputStreamProvider, QetcherClient client) {
        block39: {
            try (OutputStream out = outputStreamProvider.getOutputStream(job, resultFile);){
                if (out != null) {
                    try (TmpFile tmpFile = new TmpFile((Path)QetcherLiferayServiceImpl.getWithDownloadTimeout(client.downloadAsTempFile(resultFile.getFileId())));
                         InputStream in = Files.newInputStream(tmpFile.getFile(), new OpenOption[0]);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        break block39;
                    }
                }
                LOG.info("Ignoring output of job {}, file {}", (Object)job.getJobId(), (Object)resultFile.getFileId());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error handling result file for job " + job.getJobId(), e);
            }
        }
    }

    private void doConvert(InputStream inputStream, String sourceExtension, String targetExtension, Map<String, String> targetParameters, String jobReferer, ResultFileCallback callback) {
        LOG.info("Request for conversion from extension '{}' to extension '{}' with referer '{}'", new Object[]{sourceExtension, targetExtension, jobReferer});
        InputJob inputJob = this.newInputJob(inputStream, sourceExtension, targetExtension, targetParameters, jobReferer, LiferayClientConfiguration.getInstance());
        this.runJob(inputJob, jobReferer, callback);
    }

    private void doConvert(InputStream inputStream, MediaType fromMediaType, MediaType toMediaType, String jobReferer, ResultFileCallback callback) {
        LOG.info("Request for conversion from media type '{}' to media type '{}' with referer '{}'", new Object[]{fromMediaType, toMediaType, jobReferer});
        InputJob inputJob = this.newInputJob(inputStream, fromMediaType, toMediaType, jobReferer, LiferayClientConfiguration.getInstance());
        this.runJob(inputJob, jobReferer, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJob(InputJob inputJob, String jobReferer, ResultFileCallback callback) {
        Job createdJob = (Job)QetcherLiferayServiceImpl.getWithUploadTimeout(this.client().createJob(inputJob));
        String jobId = createdJob.getJobId();
        try {
            LiferayClientConfiguration configuration = LiferayClientConfiguration.getInstance();
            long jobWaitTimeoutMillis = configuration.getJobWaitTimeoutMillis();
            Job doneJob = (Job)QetcherLiferayServiceImpl.get(this.client().getJobDone(createdJob), jobWaitTimeoutMillis, TimeUnit.MILLISECONDS);
            if (doneJob.getResultFileIds().isEmpty()) {
                throw new QetcherClientException("Job did not produce any files. Referer: '" + jobReferer + "'");
            }
            LOG.info("Conversion job '{}' done with referer '{}' from {} to {} ", new Object[]{jobId, inputJob.getReferrer(), inputJob.getFromMediaType(), inputJob.getToMediaType()});
            LOG.info("Downloading result files for job '{}' with referer '{}' from {} to {} ", new Object[]{jobId, inputJob.getReferrer(), inputJob.getFromMediaType(), inputJob.getToMediaType()});
            doneJob.getResultFileIds().stream().map(resultFileId -> (ConversionFile)QetcherLiferayServiceImpl.getWithShortTimeout(this.client().getFile(resultFileId))).forEach(resultFile -> callback.processResultFile(doneJob, (ConversionFile)resultFile, this.client()));
            LOG.info("Downloading result files for job '{}' done with referer '{}' from {} to {} ", new Object[]{jobId, inputJob.getReferrer(), inputJob.getFromMediaType(), inputJob.getToMediaType()});
        }
        finally {
            this.client().deleteJob(jobId).whenComplete((unused, e) -> {
                if (e != null) {
                    LOG.warn("Error deleting job '{}'. Referer: '{}'", new Object[]{jobId, jobReferer, e});
                } else {
                    LOG.info("Deleted job '{}'. Referer: '{}'", (Object)jobId, (Object)jobReferer);
                }
            });
        }
    }

    @VisibleForTesting
    protected InputJob newInputJob(InputStream inputStream, String sourceExtension, String targetExtension, Map<String, String> targetParameters, String jobReferer, LiferayClientConfiguration configuration) {
        String sourceMimeTypeString = MimeTypesUtil.getExtensionContentType((String)sourceExtension);
        if (sourceMimeTypeString == null || APPLICATION_OCTETSTREAM.equals(sourceMimeTypeString)) {
            throw new QetcherClientException("Unable to map source extension to mime type: " + sourceExtension);
        }
        MediaType fromMediaType = MediaType.valueOf((String)sourceMimeTypeString);
        String targetMimeTypeString = MimeTypesUtil.getExtensionContentType((String)targetExtension);
        if (targetMimeTypeString == null || APPLICATION_OCTETSTREAM.equals(targetMimeTypeString)) {
            throw new QetcherClientException("Unable to map target extension to mime type: " + targetExtension);
        }
        if (targetParameters != null && !targetParameters.isEmpty()) {
            targetMimeTypeString = MediaType.valueOf((String)targetMimeTypeString).withParameters(targetParameters).toString();
        }
        MediaType toMediaType = MediaType.valueOf((String)targetMimeTypeString);
        return this.newInputJob(inputStream, fromMediaType, toMediaType, jobReferer, configuration);
    }

    private InputJob newInputJob(InputStream inputStream, MediaType fromMediaType, MediaType toMediaType, String jobReferer, LiferayClientConfiguration configuration) {
        LOG.info("Conversion with referer '{}' from {} to {} ", new Object[]{jobReferer, fromMediaType, toMediaType});
        InputStream actualInputStream = this.getAugmentedInputStream(fromMediaType, inputStream);
        InputConversionFile inputConversionFile = QetcherClientBuilders.inputFile().mediaType(fromMediaType).bodyProvider(BodyProviders.fromInputStream((InputStream)actualInputStream)).build();
        return QetcherClientBuilders.job().fromFile(inputConversionFile).toMediaType(toMediaType).referrer(jobReferer).deleteTimeout(Duration.ofMillis(configuration.getJobDeleteTimeoutMillis())).cancelTimeout(Duration.ofMillis(configuration.getJobCancelTimeoutMillis())).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getAugmentedInputStream(MediaType fromMediaType, InputStream inputStream) {
        if (!MediaTypes.HTML.isCompatible(fromMediaType)) return inputStream;
        String baseUrl = LiferayAbstractionFactorySupplier.getInstance().getPortalTool().getBaseUrl();
        if (baseUrl == null) {
            LOG.warn("Could not get base url - no html inlining can be done");
            return inputStream;
        }
        try (HtmlElementInliner inliner = LiferayHtmlElementInlinerFactory.newHtmlElementInliner();){
            byte[] inlinedHtml = inliner.inline(inputStream, baseUrl);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inlinedHtml);
            return byteArrayInputStream;
        }
        catch (Exception e) {
            LOG.warn("Error inlining html elements", (Throwable)e);
        }
        return inputStream;
    }

    @Override
    public String getFilePath(String id, String targetExtension) {
        StringBuilder sb = new StringBuilder(5);
        sb.append(LiferayClientConfiguration.getInstance().getDocumentConversionTargetPath());
        sb.append('/');
        sb.append(id);
        sb.append('.');
        sb.append(targetExtension);
        return sb.toString();
    }

    @Override
    public FileExtensionInfos getFileExtensions() {
        try {
            return (FileExtensionInfos)QetcherLiferayServiceImpl.getWithShortTimeout(this.client().getFileExtensions());
        }
        catch (Exception e) {
            LOG.warn("Error getting file extension infos from Qetcher service. Returning empty object.", (Throwable)e);
            return new FileExtensionInfos(Collections.emptyMap());
        }
    }

    @Override
    public Optional<MediaTypeInfo> getMediaTypeForFilename(String filename) {
        try {
            return Optional.of(QetcherLiferayServiceImpl.getWithShortTimeout(this.client().getMediaTypeForFilename(filename)));
        }
        catch (Exception e) {
            LOG.info("Error getting media type for filename from Qetcher service. Returning empty optional.");
            return Optional.empty();
        }
    }

    @Override
    public List<MediaTypeInfo> getMediaTypes() {
        try {
            return (List)QetcherLiferayServiceImpl.getWithShortTimeout(this.client().getMediaTypes());
        }
        catch (Exception e) {
            LOG.warn("Error getting media types from Qetcher service. Returning empty list.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static interface ResultFileCallback {
        public void processResultFile(Job var1, ConversionFile var2, QetcherClient var3);
    }

    private static class TmpFile
    implements Closeable {
        private final Path file;

        public TmpFile(Path file) {
            this.file = file;
        }

        public Path getFile() {
            return this.file;
        }

        @Override
        public void close() throws IOException {
            if (this.file != null) {
                Files.deleteIfExists(this.file);
            }
        }
    }
}

