/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.util.PropsValues;
import de.mklinger.qetcher.liferay.client.impl.Conversions;
import de.mklinger.qetcher.liferay.client.impl.QetcherLiferayServiceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentConversionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentConversionUtil.class);
    private static final String[] _COMPARABLE_FILE_EXTENSIONS = PropsValues.DL_COMPARABLE_FILE_EXTENSIONS;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private DocumentConversionUtil() {
    }

    public static File convert(String id, InputStream inputStream, String sourceExtension, String targetExtension) throws IOException, SystemException {
        return QetcherLiferayServiceUtil.convert(id, inputStream, sourceExtension, targetExtension);
    }

    public static String[] getConversions(String extension) {
        try {
            return Conversions.getInstance().getTargetExtensionsForExtension(extension);
        }
        catch (Exception e) {
            LOG.error("Error getting target extensions for extension '{}'", (Object)extension, (Object)e);
            return EMPTY_STRING_ARRAY;
        }
    }

    public static String getFilePath(String id, String targetExtension) {
        return QetcherLiferayServiceUtil.getFilePath(id, targetExtension);
    }

    public static boolean isComparableVersion(String extension) {
        block6: {
            boolean enabled = false;
            String dotExtension = "." + extension;
            for (String element : _COMPARABLE_FILE_EXTENSIONS) {
                if (!"*".equals(element) && !dotExtension.equals(element)) continue;
                enabled = true;
                break;
            }
            if (!enabled) {
                return false;
            }
            if (extension.equals("css") || extension.equals("htm") || extension.equals("html") || extension.equals("js") || extension.equals("txt") || extension.equals("xml")) {
                return true;
            }
            try {
                if (DocumentConversionUtil.isEnabled() && DocumentConversionUtil.isConvertBeforeCompare(extension)) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error("Error in isComparableVersion", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isConvertBeforeCompare(String extension) {
        String[] conversions;
        if (extension.equals("txt")) {
            return false;
        }
        for (String conversion : conversions = DocumentConversionUtil.getConversions(extension)) {
            if (!conversion.equals("txt")) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnabled() {
        return true;
    }

    public static void disconnect() {
    }
}

