/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl.abstraction;

import java.util.Date;

import de.mklinger.qetcher.liferay.abstraction.Image;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class LiferayImageWrapper implements Image {
	private final com.liferay.portal.model.Image delegate;

	public LiferayImageWrapper(final com.liferay.portal.model.Image delegate) {
		this.delegate = delegate;
	}

	@Override
	public String getType() {
		return delegate.getType();
	}

	@Override
	public byte[] getTextObj() {
		return delegate.getTextObj();
	}

	@Override
	public long getImageId() {
		return delegate.getImageId();
	}

	@Override
	public void setHeight(final int height) {
		delegate.setHeight(height);
	}

	@Override
	public void setWidth(final int width) {
		delegate.setWidth(width);
	}

	@Override
	public int getHeight() {
		return delegate.getHeight();
	}

	@Override
	public int getWidth() {
		return delegate.getWidth();
	}

	@Override
	public void setModifiedDate(final Date modifiedDate) {
		delegate.setModifiedDate(modifiedDate);
	}

	@Override
	public void setTextObj(final byte[] textObj) {
		delegate.setTextObj(textObj);
	}

	@Override
	public void setType(final String type) {
		delegate.setType(type);
	}
}
