/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.util.Set;

import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public abstract class MediaRegistryProcessor extends DLPreviewableProcessor {
	private final String mediaTypeRegistry;

	/**
	 * @param mediaTypeRegistry The first part of a media type,
	 *      e.g. "audio" or "video".
	 */
	public MediaRegistryProcessor(final String mediaTypeRegistry) {
		this.mediaTypeRegistry = mediaTypeRegistry;
	}

	public Set<String> getSupportedSourceMimeTypes() {
		return Conversions.getInstance().getSourceMediaTypesForRegistry(mediaTypeRegistry);
	}
}
