/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.liferay.abstraction.FileVersion;
import de.mklinger.qetcher.liferay.abstraction.LiferayException;
import de.mklinger.qetcher.liferay.client.impl.PreviewProcessorBridge;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactorySupplier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewOutputStream
extends FileOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewOutputStream.class);
    private final boolean storeThumbnail;
    private final boolean storePreview;
    private final PreviewProcessorBridge processor;
    private final File tempFile;
    private final FileVersion fileVersion;
    private final int page;
    private boolean closed;

    public PreviewOutputStream(FileVersion fileVersion, int page, boolean storeThumbnail, boolean storePreview, PreviewProcessorBridge processor) throws IOException {
        this(PreviewOutputStream.getTempFile(fileVersion, page, processor), page, storeThumbnail, storePreview, fileVersion, processor);
    }

    private PreviewOutputStream(File file, int page, boolean storeThumbnail, boolean storePreview, FileVersion fileVersion, PreviewProcessorBridge processor) throws FileNotFoundException {
        super(file);
        this.tempFile = file;
        this.page = page;
        this.fileVersion = fileVersion;
        this.storeThumbnail = storeThumbnail;
        this.storePreview = storePreview;
        this.processor = processor;
    }

    private static File getTempFile(FileVersion fileVersion, int page, PreviewProcessorBridge processor) throws IOException {
        String tempFileId = LiferayAbstractionFactorySupplier.getInstance().getDLTool().getTempFileId(fileVersion);
        File tempFile = processor.getPreviewTempFile(tempFileId, page);
        if (!tempFile.createNewFile()) {
            throw new IOException("Could not create temp file");
        }
        return tempFile;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                super.close();
                if (this.storeThumbnail) {
                    this.storeThumbnail();
                }
                if (this.storePreview) {
                    this.storePreview();
                }
            }
            finally {
                this.deleteTempFile();
            }
        }
    }

    private void storeThumbnail() {
        try {
            LOG.debug("Storing thumbnail");
            this.processor.storeThumbnailImages(this.fileVersion, this.tempFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error storing thumbnail image", e);
        }
    }

    private void storePreview() {
        try {
            LOG.debug("Storing preview page {}", (Object)this.page);
            String previewPath = LiferayAbstractionFactorySupplier.getInstance().getDLTool().getPreviewPath();
            this.processor.addFileToStore(this.fileVersion.getCompanyId(), previewPath, this.processor.getPreviewFilePath(this.fileVersion, this.page), this.tempFile);
        }
        catch (LiferayException e) {
            throw new RuntimeException("Error storing preview image", e);
        }
    }

    private void deleteTempFile() {
        try {
            Files.deleteIfExists(this.tempFile.toPath());
        }
        catch (IOException e) {
            LOG.warn("Error deleting tmp file", (Throwable)e);
        }
    }
}

