/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl.abstraction;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SystemProperties;

import de.mklinger.qetcher.liferay.abstraction.PropsTool;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class PropsToolImpl implements PropsTool {
	@Override
	public String getString(final String key, final String defaultValue) {
		final String s = PropsUtil.get(key);
		if (s == null) {
			return defaultValue;
		}
		return s;
	}

	@Override
	public int getInteger(final String key, final int defaultValue) {
		return GetterUtil.getInteger(PropsUtil.get(key), defaultValue);
	}

	@Override
	public long getLong(final String key, final long defaultValue) {
		return GetterUtil.getLong(PropsUtil.get(key), defaultValue);
	}

	@Override
	public boolean getBoolean(final String key, final boolean defaultValue) {
		return GetterUtil.getBoolean(PropsUtil.get(key), defaultValue);
	}

	@Override
	public String[] getArray(final String key) {
		return PropsUtil.getArray(key);
	}

	@Override
	public String getSystemProperty(final String key) {
		return SystemProperties.get(key);
	}
}
