package de.mklinger.qetcher.liferay.client.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;

import de.mklinger.qetcher.client.jackson.core.type.TypeReference;
import de.mklinger.qetcher.client.jackson.databind.ObjectMapper;
import de.mklinger.qetcher.client.maps.Maps;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;

public class QetcherRawMetadataProcessor {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherRawMetadataProcessor.class);

	private static final MediaType METADATA_FROM = MediaType.valueOf("application/octet-stream");
	private static final MediaType METADATA_TO = MediaTypes.JSON.withParameter("extractMetadata", "true");

	public Map<String, String> extractMetadata(final InputStream inputStream, final String referrer) throws PortalException, SystemException {
		LOG.info("Getting metadata with referrer '{}'", referrer);

		final Map<String, Object> rawMetadata;

		try {
			rawMetadata = extractRawMetadata(
					inputStream,
					referrer);
		} catch (final IOException e) {
			throw new SystemException(e);
		}

		final HashMap<String, String> metadata = Maps.newHashMap(rawMetadata.size());

		for (final Entry<String, Object> e : rawMetadata.entrySet()) {
			final String name = e.getKey();
			final Object value = e.getValue();
			if (value instanceof String) {
				LOG.debug("Metadata: {} -> '{}'", name, value);
				metadata.put(name, (String) value);
			}
		}

		return metadata;
	}

	private Map<String, Object> extractRawMetadata(final InputStream inputStream, final String referrer) throws IOException {
		final ByteArrayOutputStream bout = new ByteArrayOutputStream();

		QetcherLiferayServiceUtil.convert(
				inputStream,
				bout,
				METADATA_FROM,
				METADATA_TO,
				referrer);

		return parseJson(bout.toByteArray());
	}

	private Map<String, Object> parseJson(final byte[] json) throws IOException {
		final TypeReference<HashMap<String, Object>> stringMap = new TypeReference<HashMap<String, Object>>() {};
		final ObjectMapper objectMapper = new ObjectMapper();
		return objectMapper.readValue(json, stringMap);
	}
}
