/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.FileExtensionInfos;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypeInfo;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetcherLiferayServiceUtil {
	private static volatile QetcherLiferayService service;

	private static QetcherLiferayService getService() {
		if (service == null) {
			synchronized (QetcherLiferayService.class) {
				if (service == null) {
					service = new QetcherLiferayServiceImpl();
				}
			}
		}
		return service;
	}

	public static List<AvailableConversion> getAvailableConversions() {
		return getService().getAvailableConversions();
	}

	public static void convert(final InputStream inputStream, final PreviewOutputStreamProvider outputStreamProvider,
			final String sourceExtension, final String targetExtension, final Map<String, String> targetParameters,
			final String jobReferer) throws IOException {
		getService().convert(inputStream, outputStreamProvider, sourceExtension, targetExtension, targetParameters, jobReferer);
	}

	public static File convert(final String id, final InputStream inputStream,
			final String sourceExtension, final String targetExtension) throws IOException {
		return getService().convert(id, inputStream, sourceExtension, targetExtension);
	}

	public static void convert(final InputStream inputStream, final OutputStream outputStream,
			final String sourceExtension, final String targetExtension,
			final Map<String, String> targetParameters, final String jobReferer) throws IOException {
		getService().convert(inputStream, outputStream, sourceExtension, targetExtension, targetParameters, jobReferer);
	}

	public static void convert(final InputStream inputStream, final OutputStream outputStream,
			final MediaType fromMediaType, final MediaType toMediaType,
			final String jobReferer) throws IOException {
		getService().convert(inputStream, outputStream, fromMediaType, toMediaType, jobReferer);
	}

	public static String getFilePath(final String id, final String targetExtension) {
		return getService().getFilePath(id, targetExtension);
	}

	public static FileExtensionInfos getFileExtensions() {
		return getService().getFileExtensions();
	}

	public static Optional<MediaTypeInfo> getMediaTypeForFilename(final String filename) {
		return getService().getMediaTypeForFilename(filename);
	}

	public static List<MediaTypeInfo> getMediaTypes() {
		return getService().getMediaTypes();
	}
}
