/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.io.IOException;
import java.io.OutputStream;

import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.liferay.abstraction.FileVersion;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class PreviewOutputStreamProvider implements OutputStreamProvider {
	private final PreviewProcessorBridge processor;
	private final FileVersion fileVersion;
	private final boolean storeThumbnail;
	private final boolean storePreview;
	private int page = 0;

	public PreviewOutputStreamProvider(final FileVersion fileVersion, final boolean storeThumbnail, final boolean storePreview, final PreviewProcessorBridge processor) {
		this.fileVersion = fileVersion;
		this.storeThumbnail = storeThumbnail;
		this.storePreview = storePreview;
		this.processor = processor;
	}

	@Override
	public OutputStream getOutputStream(final Job job, final ConversionFile resultFile) {
		page++;
		try {
			return new PreviewOutputStream(fileVersion, page, storeThumbnail && page == 1, storePreview, processor);
		} catch (final IOException e) {
			throw new QetcherClientException("Error processing preview file", e);
		}
	}
}