/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.micro.annotations.VisibleForTesting;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Enumeration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QetcherClientCertificateInfo {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherClientCertificateInfo.class);
    private static final Duration WARN_THRESHOLD = Duration.ofDays(14L);
    private final KeyStore keyStore;
    private final Clock clock;

    public QetcherClientCertificateInfo(KeyStore keyStore) {
        this(keyStore, Clock.systemUTC());
    }

    @VisibleForTesting
    protected QetcherClientCertificateInfo(KeyStore keyStore, Clock clock) {
        this.keyStore = keyStore;
        this.clock = clock;
    }

    public void log() {
        this.log(LOG);
    }

    @VisibleForTesting
    protected void log(Logger logger) {
        Optional<ZonedDateTime> notAfter = QetcherClientCertificateInfo.getNotAfter(this.keyStore);
        if (notAfter.isPresent()) {
            logger.info("Qetcher client certificate is valid until {}", (Object)notAfter.get());
            ZonedDateTime now = ZonedDateTime.now(this.clock);
            if (now.isAfter(notAfter.get())) {
                this.logExpired(logger);
            } else if (now.plus(WARN_THRESHOLD).isAfter(notAfter.get())) {
                Duration validDuration = Duration.between(now, notAfter.get());
                this.logAboutToExpire(logger, validDuration);
            }
        } else {
            logger.warn("Unable to lookup Qetcher client certificate validity");
        }
    }

    private static Optional<ZonedDateTime> getNotAfter(KeyStore keyStore) {
        try {
            return Optional.ofNullable(QetcherClientCertificateInfo.getEarliestNotAfter(keyStore));
        }
        catch (Exception e) {
            LOG.warn("Error looking up Qetcher client certificate validity", (Throwable)e);
            return Optional.empty();
        }
    }

    private static ZonedDateTime getEarliestNotAfter(KeyStore keyStore) throws KeyStoreException {
        ZonedDateTime earliestNotAfter = null;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate[] certificateChain;
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            for (Certificate c : certificateChain = keyStore.getCertificateChain(alias)) {
                X509Certificate certificate = (X509Certificate)c;
                ZonedDateTime notAfter = ZonedDateTime.ofInstant(certificate.getNotAfter().toInstant(), ZoneId.of("UTC"));
                if (earliestNotAfter != null && !earliestNotAfter.isAfter(notAfter)) continue;
                earliestNotAfter = notAfter;
            }
        }
        return earliestNotAfter;
    }

    private void logExpired(Logger logger) {
        logger.error("*********************************************************************");
        logger.error("* Qetcher client certificate is expired.");
        logger.error("*");
        logger.error("* Please contact Qetcher support to obtain a new certificate.");
        logger.error("*********************************************************************");
    }

    private void logAboutToExpire(Logger logger, Duration validDuration) {
        logger.warn("*********************************************************************");
        logger.warn("* Qetcher client certificate is about to expire.");
        logger.warn("*");
        logger.warn("* It will expire in {} day(s)", (Object)validDuration.toDays());
        logger.warn("*");
        logger.warn("* Please contact Qetcher support to obtain a new certificate.");
        logger.warn("*********************************************************************");
    }
}

