/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.util.MimeTypesUtil;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.liferay.abstraction.CacheTool;
import de.mklinger.qetcher.liferay.client.impl.LiferayClientConfiguration;
import de.mklinger.qetcher.liferay.client.impl.QetcherLiferayServiceUtil;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactorySupplier;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversions {
    private static final Conversions INSTANCE = new Conversions();
    private static final String CACHE_NAME = "de.mklinger.qetcher.liferay.ConversionsCache";
    private static final String CONVERSIONS_EXTENSIONS_PREFIX = "conversionsExtensions_";
    private static final String CONVERSIONS_KEY = "conversions";
    private static final String SOURCE_MEDIA_TYPES_REGISTRY_PREFIX = "sourceMediaTypesRegistry_";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Logger LOG = LoggerFactory.getLogger(Conversions.class);

    protected Conversions() {
    }

    public static Conversions getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTargetExtensionsForExtension(String extension) {
        if (extension == null || extension.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = this.getTargetExtensionsFromCache(extension);
        if (result == null) {
            Conversions conversions = this;
            synchronized (conversions) {
                result = this.getTargetExtensionsFromCache(extension);
                if (result == null) {
                    result = this.loadTargetExtensions(extension);
                    this.putTargetExtensionsToCache(extension, result);
                }
            }
        }
        return result;
    }

    private String[] loadTargetExtensions(String extension) {
        String[] newResult;
        Map<String, Set<String>> supportedConversionsExtensions = this.getSupportedConversionsExtensions();
        Set<String> targetExtensions = supportedConversionsExtensions.get(extension);
        if (targetExtensions == null || targetExtensions.isEmpty()) {
            LOG.info("Found no conversions for source extension {}", (Object)extension);
            newResult = EMPTY_STRING_ARRAY;
        } else {
            LOG.info("Found {} conversions for source extension {}", (Object)targetExtensions.size(), (Object)extension);
            Set<String> extensionWhitelist = this.getExtensionWhitelist(extension);
            if (extensionWhitelist != null && !extensionWhitelist.isEmpty() || targetExtensions.contains(extension)) {
                targetExtensions = new HashSet<String>(targetExtensions);
                targetExtensions.remove(extension);
                if (extensionWhitelist != null) {
                    targetExtensions.retainAll(extensionWhitelist);
                }
            }
            newResult = targetExtensions.isEmpty() ? EMPTY_STRING_ARRAY : targetExtensions.toArray(new String[targetExtensions.size()]);
        }
        return newResult;
    }

    protected Set<String> getExtensionWhitelist(String extension) {
        LiferayClientConfiguration configuration = LiferayClientConfiguration.getInstance();
        Set<String> extensionWhitelist = configuration.getConversionExtensionsSinglepage().contains(extension) ? configuration.getConversionExtensionsWhitelistSinglepage() : configuration.getConversionExtensionsWhitelistMultipage();
        return extensionWhitelist;
    }

    private String[] getTargetExtensionsFromCache(String extension) {
        String cacheKey = CONVERSIONS_EXTENSIONS_PREFIX + extension;
        String[] cachedResult = (String[])this.getCacheTool().get(CACHE_NAME, cacheKey);
        if (LOG.isDebugEnabled()) {
            if (cachedResult != null) {
                LOG.debug("Cache hit for {}", (Object)cacheKey);
            } else {
                LOG.debug("Cache miss for {}", (Object)cacheKey);
            }
        }
        return cachedResult;
    }

    private void putTargetExtensionsToCache(String extension, String[] targetExtensions) {
        String cacheKey = CONVERSIONS_EXTENSIONS_PREFIX + extension;
        this.getCacheTool().put(CACHE_NAME, cacheKey, (Serializable)targetExtensions);
    }

    private Map<String, Set<String>> getSupportedConversionsExtensions() {
        HashMap<String, Set<String>> supportedConversionsExtensions = new HashMap<String, Set<String>>();
        List<AvailableConversion> availableConversions = this.getAvailableConversions();
        for (AvailableConversion availableConversion : availableConversions) {
            Conversion conversion = availableConversion.getConversion();
            MediaType from = conversion.getFrom();
            Set<String> fromExtensions = this.getExtensionsWithoutLeadingDot(from);
            if (fromExtensions == null) continue;
            for (String fromExtension : fromExtensions) {
                this.addExtensions(supportedConversionsExtensions, fromExtension, conversion.getTo());
            }
        }
        return supportedConversionsExtensions;
    }

    private void addExtensions(Map<String, Set<String>> supportedConversionsExtensions, String fromExtension, MediaType to) {
        Set toExtensions = supportedConversionsExtensions.computeIfAbsent(fromExtension, unused -> new HashSet());
        Set<String> newToExtensions = this.getExtensionsWithoutLeadingDot(to);
        if (newToExtensions != null) {
            toExtensions.addAll(newToExtensions);
        }
    }

    private Set<String> getExtensionsWithoutLeadingDot(MediaType from) {
        Set extensions = MimeTypesUtil.getExtensions((String)from.getFullType());
        if (extensions == null || extensions.isEmpty()) {
            return extensions;
        }
        LinkedHashSet<String> extensionsWithoutLeadingDot = new LinkedHashSet<String>(extensions.size());
        for (String extension : extensions) {
            if (extension == null) continue;
            extensionsWithoutLeadingDot.add(this.getExtensionWithoutLeadingDot(extension));
        }
        return extensionsWithoutLeadingDot;
    }

    private String getExtensionWithoutLeadingDot(String extension) {
        if (extension.startsWith(".") && extension.length() > 1) {
            return extension.substring(1);
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AvailableConversion> getAvailableConversions() {
        List<AvailableConversion> conversions = this.getAvailableConversionsFromCache();
        if (conversions == null) {
            Conversions conversions2 = this;
            synchronized (conversions2) {
                conversions = this.getAvailableConversionsFromCache();
                if (conversions == null) {
                    conversions = this.loadAvailableConversions();
                    if (conversions == null || conversions.isEmpty()) {
                        LOG.warn("No conversions available");
                        return Collections.emptyList();
                    }
                    this.putAvailableConversionsToCache(conversions);
                }
            }
        }
        return conversions;
    }

    private List<AvailableConversion> getAvailableConversionsFromCache() {
        List conversions = (List)this.getCacheTool().get(CACHE_NAME, CONVERSIONS_KEY);
        if (LOG.isDebugEnabled()) {
            if (conversions == null) {
                LOG.debug("Cache miss for {}", (Object)CONVERSIONS_KEY);
            } else {
                LOG.debug("Cache hit for {}", (Object)CONVERSIONS_KEY);
            }
        }
        return conversions;
    }

    private void putAvailableConversionsToCache(List<AvailableConversion> conversions) {
        this.getCacheTool().put(CACHE_NAME, CONVERSIONS_KEY, (Serializable)((Object)conversions));
    }

    protected List<AvailableConversion> loadAvailableConversions() {
        return QetcherLiferayServiceUtil.getAvailableConversions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSourceMediaTypesForRegistry(String registry) {
        HashSet<String> result = this.getSupportedSourceMimeTypesFromCache(registry);
        if (result == null) {
            Conversions conversions = this;
            synchronized (conversions) {
                result = this.getSupportedSourceMimeTypesFromCache(registry);
                if (result == null) {
                    result = this.loadSupportedSourceMimeTypes(registry);
                    this.putSupportedSourceMimeTypesToCache(registry, result);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private HashSet<String> getSupportedSourceMimeTypesFromCache(String registry) {
        String cacheKey = SOURCE_MEDIA_TYPES_REGISTRY_PREFIX + registry;
        HashSet cachedResult = (HashSet)this.getCacheTool().get(CACHE_NAME, cacheKey);
        if (LOG.isDebugEnabled()) {
            if (cachedResult != null) {
                LOG.debug("Cache hit for {}", (Object)cacheKey);
            } else {
                LOG.debug("Cache miss for {}", (Object)cacheKey);
            }
        }
        return cachedResult;
    }

    private void putSupportedSourceMimeTypesToCache(String registry, HashSet<String> mimeTypes) {
        String cacheKey = SOURCE_MEDIA_TYPES_REGISTRY_PREFIX + registry;
        this.getCacheTool().put(CACHE_NAME, cacheKey, mimeTypes);
    }

    protected CacheTool getCacheTool() {
        return LiferayAbstractionFactorySupplier.getInstance().getCacheTool();
    }

    private HashSet<String> loadSupportedSourceMimeTypes(String registry) {
        MediaType registryMediaType = new MediaType(registry, "*");
        List<AvailableConversion> availableConversions = this.getAvailableConversions();
        HashSet<String> mimeTypes = new HashSet<String>();
        for (AvailableConversion availableConversion : availableConversions) {
            MediaType from = availableConversion.getConversion().getFrom();
            if (!from.isCompatible(registryMediaType)) continue;
            mimeTypes.add(from.getFullType());
        }
        return mimeTypes;
    }
}

