/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.util.PropsValues;

import de.mklinger.qetcher.liferay.abstraction.LiferayException;

/**
 * Based on the Liferay 6.1.2 original class.
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class DocumentConversionUtil {
	private static final Logger LOG = LoggerFactory.getLogger(DocumentConversionUtil.class);

	private static final String[] _COMPARABLE_FILE_EXTENSIONS = PropsValues.DL_COMPARABLE_FILE_EXTENSIONS;
	private static final String[] EMPTY_STRING_ARRAY = new String[0];

	private DocumentConversionUtil() {
	}

	public static File convert(final String id, final InputStream inputStream, final String sourceExtension, final String targetExtension) throws IOException, SystemException {
		try {
			return QetcherLiferayServiceUtil.convert(id, inputStream, sourceExtension, targetExtension);
		} catch (final LiferayException e) {
			throw new SystemException(e);
		}
	}

	public static String[] getConversions(final String extension) {
		try {
			return Conversions.getInstance().getTargetExtensionsForExtension(extension);
		} catch (final Exception e) {
			// something went wrong when communicating with Qetcher.
			// Log the error here and do not propagate. Return an
			// empty array instead, indicating no conversions available.
			LOG.error("Error getting target extensions for extension '{}'", extension, e);
			return EMPTY_STRING_ARRAY;
		}
	}

	public static String getFilePath(final String id, final String targetExtension) {
		// TODO where is this used?
		return QetcherLiferayServiceUtil.getFilePath(id, targetExtension);
	}

	public static boolean isComparableVersion(final String extension) {
		// TODO adapt to qetcher - where is this used?
		boolean enabled = false;

		final String dotExtension = StringPool.PERIOD + extension;

		for (final String element : _COMPARABLE_FILE_EXTENSIONS) {
			if (StringPool.STAR.equals(element) || dotExtension.equals(element)) {
				enabled = true;
				break;
			}
		}

		if (!enabled) {
			return false;
		}

		if (extension.equals("css") || extension.equals("htm") ||
				extension.equals("html") || extension.equals("js") ||
				extension.equals("txt") || extension.equals("xml")) {

			return true;
		}

		try {
			if (isEnabled() && isConvertBeforeCompare(extension)) {
				return true;
			}
		}
		catch (final Exception e) {
			if (LOG.isErrorEnabled()) {
				LOG.error("Error in isComparableVersion", e);
			}
		}

		return false;
	}

	public static boolean isConvertBeforeCompare(final String extension) {
		// TODO adapt to qetcher - where is this used?
		if (extension.equals("txt")) {
			return false;
		}

		final String[] conversions = getConversions(extension);

		for (final String conversion : conversions) {
			if (conversion.equals("txt")) {
				return true;
			}
		}

		return false;
	}

	public static boolean isEnabled() {
		return true;
	}

	public static void disconnect() {
	}
}