/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.VideoProcessor;
import de.mklinger.qetcher.liferay.client.impl.MediaRegistryProcessor;
import de.mklinger.qetcher.liferay.client.impl.QetcherLiferayServiceUtil;
import de.mklinger.qetcher.liferay.client.impl.mediatype.MediaTypesService;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoProcessorImpl
extends MediaRegistryProcessor
implements VideoProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(VideoProcessorImpl.class);
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_CONTAINERS;
    private static Log _log = LogFactoryUtil.getLog(VideoProcessorImpl.class);
    private final List<Long> _fileVersionIds = new Vector<Long>();

    public VideoProcessorImpl() {
        super("video");
    }

    private void _generateVideoQetcher(FileVersion fileVersion, File srcFile, File destFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        String sourceExtension = this.getExtension(fileVersion);
        if (sourceExtension == null) {
            return;
        }
        try (FileInputStream in = new FileInputStream(srcFile);
             FileOutputStream out = new FileOutputStream(destFile);){
            if (sourceExtension.equals(containerType)) {
                LOG.info("Using original file as preview for type {}", (Object)sourceExtension);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            } else {
                LOG.debug("Generating video preview from {} to {}", (Object)sourceExtension, (Object)containerType);
                QetcherLiferayServiceUtil.convert((InputStream)in, out, sourceExtension, containerType, this.getVideoTargetParameters(containerType), this.getReferer(fileVersion));
                LOG.debug("Generating video preview done.");
            }
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destFile);
    }

    private Map<String, String> getVideoTargetParameters(String containerType) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateThumbnailQetcher(FileVersion fileVersion, File file, int height, int width) throws Exception {
        String tempFileId = DLUtil.getTempFileId((long)fileVersion.getFileEntryId(), (String)fileVersion.getVersion());
        File thumbnailTempFile = this.getThumbnailTempFile(tempFileId);
        try {
            String sourceExtension = this.getExtension(fileVersion);
            if (sourceExtension == null) {
                return;
            }
            LOG.debug("Generating video thumbnail from {} to {}", (Object)sourceExtension, (Object)"jpg");
            try (FileInputStream in = new FileInputStream(file);
                 FileOutputStream out = new FileOutputStream(thumbnailTempFile);){
                QetcherLiferayServiceUtil.convert((InputStream)in, out, sourceExtension, "jpg", null, this.getReferer(fileVersion));
            }
            LOG.debug("Generating video thumbnail done.");
            this.storeThumbnailImages(fileVersion, thumbnailTempFile);
        }
        finally {
            FileUtil.delete((File)thumbnailTempFile);
        }
    }

    private String getReferer(FileVersion fileVersion) {
        return "companyId=" + fileVersion.getCompanyId() + ",fileEntryId=" + fileVersion.getFileEntryId();
    }

    private String getExtension(FileVersion fileVersion) {
        String mimeTypeString = fileVersion.getMimeType();
        LOG.debug("Original source file mime type: {}", (Object)mimeTypeString);
        LOG.debug("Original source file extension: {}", (Object)fileVersion.getExtension());
        String sourceExtension = MediaTypesService.getInstance().getFileExtensionByMimeType(mimeTypeString).orElse(fileVersion.getExtension());
        if (sourceExtension == null || sourceExtension.isEmpty()) {
            LOG.warn("Could not determine source file extension for file entry {}", (Object)fileVersion.getFileEntryId());
            return null;
        }
        return sourceExtension;
    }

    public void afterPropertiesSet() {
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void generateVideo(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateVideo(sourceFileVersion, destinationFileVersion);
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public InputStream getThumbnailAsStream(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public Set<String> getVideoMimeTypes() {
        return this.getSupportedSourceMimeTypes();
    }

    public boolean hasVideo(FileVersion fileVersion) {
        boolean hasVideo = false;
        try {
            hasVideo = this._hasVideo(fileVersion);
            if (!hasVideo && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasVideo;
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        return this.getVideoMimeTypes().contains(mimeType);
    }

    public boolean isVideoSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isVideoSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "video");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            for (String previewType : _PREVIEW_TYPES) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "video", previewType);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return "jpg";
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        for (String previewType : _PREVIEW_TYPES) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "video", previewType);
        }
    }

    protected void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
        if (!this.hasThumbnail(fileVersion, 0)) {
            this.addFileToStore(fileVersion.getCompanyId(), "document_thumbnail/", this.getThumbnailFilePath(fileVersion, 0), file);
        }
        if (this.isThumbnailEnabled(1) || this.isThumbnailEnabled(2)) {
            ImageBag imageBag = ImageToolUtil.read((File)file);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            this.storeThumbnailImage(fileVersion, renderedImage, 1);
            this.storeThumbnailImage(fileVersion, renderedImage, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void _generateVideo(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block22: {
            File videoTempFile;
            InputStream inputStream;
            block21: {
                block20: {
                    if (this._hasVideo(destinationFileVersion)) {
                        return;
                    }
                    inputStream = null;
                    videoTempFile = null;
                    if (sourceFileVersion == null) break block20;
                    this.copy(sourceFileVersion, destinationFileVersion);
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    FileUtil.delete(videoTempFile);
                    return;
                }
                try {
                    File file = null;
                    if (!this.hasPreviews(destinationFileVersion) || !this.hasThumbnails(destinationFileVersion)) {
                        if (destinationFileVersion instanceof LiferayFileVersion) {
                            try {
                                LiferayFileVersion liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
                                file = liferayFileVersion.getFile(false);
                            }
                            catch (UnsupportedOperationException liferayFileVersion) {
                                // empty catch block
                            }
                        }
                        if (file == null) {
                            inputStream = destinationFileVersion.getContentStream(false);
                            videoTempFile = FileUtil.createTempFile((String)destinationFileVersion.getExtension());
                            FileUtil.write((File)videoTempFile, (InputStream)inputStream);
                            file = videoTempFile;
                        }
                    }
                    if (!this.hasPreviews(destinationFileVersion)) {
                        String tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
                        for (String previewType : _PREVIEW_TYPES) {
                            File previewTempFile = this.getPreviewTempFile(tempFileId, previewType);
                            try {
                                this._generateVideoQetcher(destinationFileVersion, file, previewTempFile, previewType);
                            }
                            catch (Exception e) {
                                _log.error((Object)e, (Throwable)e);
                            }
                            finally {
                                FileUtil.delete((File)previewTempFile);
                            }
                        }
                    }
                    if (this.hasThumbnails(destinationFileVersion)) break block21;
                    try {
                        this._generateThumbnailQetcher(destinationFileVersion, file, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_HEIGHT, PropsValues.DL_FILE_ENTRY_PREVIEW_VIDEO_WIDTH);
                    }
                    catch (Exception e) {
                        _log.error((Object)e, (Throwable)e);
                    }
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    FileUtil.delete(videoTempFile);
                    break block22;
                    catch (Throwable throwable) {
                        StreamUtil.cleanUp(inputStream);
                        this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                        FileUtil.delete(videoTempFile);
                        throw throwable;
                    }
                }
            }
            StreamUtil.cleanUp((InputStream)inputStream);
            this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            FileUtil.delete((File)videoTempFile);
        }
    }

    private boolean _hasVideo(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        return this.hasPreviews(fileVersion) && this.hasThumbnails(fileVersion);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_video_processor", sourceFileVersion, destinationFileVersion);
    }
}

