/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.util.AudioProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import de.mklinger.qetcher.liferay.client.impl.MediaRegistryProcessor;
import de.mklinger.qetcher.liferay.client.impl.QetcherLiferayServiceUtil;
import de.mklinger.qetcher.liferay.client.impl.mediatype.MediaTypesService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioProcessorImpl
extends MediaRegistryProcessor
implements AudioProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AudioProcessorImpl.class);
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_CONTAINERS;
    private static Log _log = LogFactoryUtil.getLog(AudioProcessorImpl.class);
    private final List<Long> _fileVersionIds = new Vector<Long>();

    public AudioProcessorImpl() {
        super("audio");
    }

    private void _generateAudioQetcher(FileVersion fileVersion, File srcFile, File destFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        String sourceExtension = this.getExtension(fileVersion);
        if (sourceExtension == null) {
            return;
        }
        try (FileInputStream in = new FileInputStream(srcFile);
             FileOutputStream out = new FileOutputStream(destFile);){
            if ("mp3".equals(sourceExtension) && sourceExtension.equals(containerType)) {
                LOG.info("Using original file as preview for type {}", (Object)sourceExtension);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            } else {
                LOG.debug("Generating audio preview from {} to {}", (Object)sourceExtension, (Object)containerType);
                QetcherLiferayServiceUtil.convert((InputStream)in, out, sourceExtension, containerType, null, this.getReferer(fileVersion));
                LOG.debug("Generating audio preview done.");
            }
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destFile);
    }

    private String getReferer(FileVersion fileVersion) {
        return "companyId=" + fileVersion.getCompanyId() + ",fileEntryId=" + fileVersion.getFileEntryId();
    }

    private String getExtension(FileVersion fileVersion) {
        String mimeTypeString = fileVersion.getMimeType();
        LOG.debug("Original source file mime type: {}", (Object)mimeTypeString);
        LOG.debug("Original source file extension: {}", (Object)fileVersion.getExtension());
        String sourceExtension = MediaTypesService.getInstance().getFileExtensionByMimeType(mimeTypeString).orElse(fileVersion.getExtension());
        if (sourceExtension == null || sourceExtension.isEmpty()) {
            LOG.warn("Could not determine source file extension for file entry {}", (Object)fileVersion.getFileEntryId());
            return null;
        }
        return sourceExtension;
    }

    public void afterPropertiesSet() {
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
    }

    public void generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateAudio(sourceFileVersion, destinationFileVersion);
    }

    public Set<String> getAudioMimeTypes() {
        return this.getSupportedSourceMimeTypes();
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public boolean hasAudio(FileVersion fileVersion) {
        boolean hasAudio = false;
        try {
            hasAudio = this._hasAudio(fileVersion);
            if (!hasAudio && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasAudio;
    }

    public boolean isAudioSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isAudioSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        return this.getAudioMimeTypes().contains(mimeType);
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            for (String previewType : _PREVIEW_TYPES) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "audio", previewType);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return null;
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        for (String previewType : _PREVIEW_TYPES) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "audio", previewType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block15: {
            String tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
            File[] previewTempFiles = new File[_PREVIEW_TYPES.length];
            for (int i = 0; i < _PREVIEW_TYPES.length; ++i) {
                previewTempFiles[i] = this.getPreviewTempFile(tempFileId, _PREVIEW_TYPES[i]);
            }
            File audioTempFile = null;
            InputStream inputStream = null;
            try {
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                audioTempFile = FileUtil.createTempFile((String)destinationFileVersion.getExtension());
                if (this.hasPreviews(destinationFileVersion)) break block15;
                File file = null;
                if (destinationFileVersion instanceof LiferayFileVersion) {
                    try {
                        LiferayFileVersion liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
                        file = liferayFileVersion.getFile(false);
                    }
                    catch (UnsupportedOperationException liferayFileVersion) {
                        // empty catch block
                    }
                }
                if (file == null) {
                    inputStream = destinationFileVersion.getContentStream(false);
                    FileUtil.write((File)audioTempFile, (InputStream)inputStream);
                    file = audioTempFile;
                }
                try {
                    this._generateAudio(destinationFileVersion, file, previewTempFiles);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
            }
            finally {
                StreamUtil.cleanUp(inputStream);
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                for (File previewTempFile : previewTempFiles) {
                    FileUtil.delete((File)previewTempFile);
                }
                FileUtil.delete((File)audioTempFile);
            }
        }
    }

    private void _generateAudio(FileVersion fileVersion, File srcFile, File[] destFiles) {
        try {
            for (int i = 0; i < destFiles.length; ++i) {
                this._generateAudioQetcher(fileVersion, srcFile, destFiles[i], _PREVIEW_TYPES[i]);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private boolean _hasAudio(FileVersion fileVersion) throws Exception {
        if (!this.isSupported(fileVersion)) {
            return false;
        }
        return this.hasPreviews(fileVersion);
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_audio_processor", sourceFileVersion, destinationFileVersion);
    }
}

