/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl.abstraction;

import java.io.Serializable;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;

import de.mklinger.qetcher.liferay.abstraction.CacheTool;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class CacheToolImpl implements CacheTool {
	@Override
	public Object get(final String cacheName, final String cacheKey) {
		return MultiVMPoolUtil.getCache(cacheName).get(cacheKey);
	}

	@Override
	public void put(final String cacheName, final String cacheKey, final Serializable value) {
		MultiVMPoolUtil.getCache(cacheName).put(cacheKey, value);
	}
}
