/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.mediatype;

import de.mklinger.qetcher.client.lists.Lists;
import de.mklinger.qetcher.client.maps.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jsoup.UncheckedIOException;

public class MediaTypesService {
    private static final MediaTypesService INSTANCE = new MediaTypesService();
    private volatile Map<String, List<String>> extensionsByMediaType = null;
    private volatile Properties mediaTypeByExtension = null;

    public static MediaTypesService getInstance() {
        return INSTANCE;
    }

    public Optional<String> getFileExtensionByMimeType(String mediaType) {
        List<String> extensions = this.getExtensionsByMediaType().get(mediaType);
        if (extensions == null || extensions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(extensions.get(0));
    }

    public List<String> getFileExtensionsByMimeType(String mediaType) {
        return this.getExtensionsByMediaType().get(mediaType);
    }

    public Optional<String> getMimeTypeStringByExtension(String extension) {
        return Optional.ofNullable(this.getMediaTypeByExtension().getProperty(extension.toLowerCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getExtensionsByMediaType() {
        if (this.extensionsByMediaType == null) {
            MediaTypesService mediaTypesService = this;
            synchronized (mediaTypesService) {
                if (this.extensionsByMediaType == null) {
                    this.extensionsByMediaType = this.loadExtensionsByMediaType();
                }
            }
        }
        return this.extensionsByMediaType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> loadExtensionsByMediaType() {
        try (InputStream in = this.getClass().getResourceAsStream("extensions-by-mediatype.properties");){
            Properties p = new Properties();
            p.load(in);
            HashMap map = Maps.newHashMap((int)p.size());
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String values = (String)entry.getValue();
                ArrayList<String> extensions = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(values, ",");
                while (st.hasMoreTokens()) {
                    String extension = st.nextToken();
                    extensions.add(extension);
                }
                map.put(key, Lists.newImmutableList(extensions));
            }
            Map map2 = Maps.newImmutableMap((Map)map);
            return map2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getMediaTypeByExtension() {
        if (this.mediaTypeByExtension == null) {
            MediaTypesService mediaTypesService = this;
            synchronized (mediaTypesService) {
                if (this.mediaTypeByExtension == null) {
                    this.mediaTypeByExtension = this.loadMediaTypeByExtension();
                }
            }
        }
        return this.mediaTypeByExtension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadMediaTypeByExtension() {
        try (InputStream in = this.getClass().getResourceAsStream("mediatype-by-extension.properties");){
            Properties p = new Properties();
            p.load(in);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

