/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.qetcher.client.sets.Sets;
import de.mklinger.qetcher.liferay.abstraction.PropsTool;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactorySupplier;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class LiferayClientConfiguration {
    private static final String TMP_DIR = "java.io.tmpdir";
    private static volatile LiferayClientConfiguration instance;
    private final String[] serviceAddresses;
    private final String keyStoreLocation;
    private final Optional<String> keyStorePassword;
    private final Optional<String> keyStoreType;
    private final Optional<String> keyPassword;
    private final String trustStoreLocation;
    private final Optional<String> trustStorePassword;
    private final Optional<String> trustStoreType;
    private final String documentConversionTargetPath;
    private final Set<String> conversionExtensionsSinglepage;
    private final Set<String> conversionExtensionsWhitelistSinglepage;
    private final Set<String> conversionExtensionsWhitelistMultipage;
    private final boolean storePdfAsPreview;
    private final boolean inlineCssForHtml;
    private final boolean inlineJsForHtml;
    private final boolean inlineExternalImagesForHtml;
    private final boolean inlineInternalImagesForHtml;
    private final long jobWaitTimeoutMillis;
    private final long jobCancelTimeoutMillis;
    private final long jobDeleteTimeoutMillis;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LiferayClientConfiguration getInstance() {
        if (instance != null) return instance;
        Class<LiferayClientConfiguration> clazz = LiferayClientConfiguration.class;
        synchronized (LiferayClientConfiguration.class) {
            if (instance != null) return instance;
            instance = new LiferayClientConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    protected LiferayClientConfiguration() {
        PropsTool propsTool = LiferayAbstractionFactorySupplier.getInstance().getPropsTool();
        this.serviceAddresses = propsTool.getArray("de.mklinger.qetcher.service.addresses");
        this.keyStoreLocation = Objects.requireNonNull(propsTool.getString("de.mklinger.qetcher.client.keyStoreLocation", null), () -> "Missing required Qetcher property de.mklinger.qetcher.client.keyStoreLocation");
        this.keyStorePassword = Optional.ofNullable(propsTool.getString("de.mklinger.qetcher.client.keyStorePassword", null));
        this.keyStoreType = Optional.ofNullable(propsTool.getString("de.mklinger.qetcher.client.keyStoreType", null));
        this.keyPassword = Optional.ofNullable(propsTool.getString("de.mklinger.qetcher.client.keyPassword", null));
        this.trustStoreLocation = Objects.requireNonNull(propsTool.getString("de.mklinger.qetcher.client.trustStoreLocation", null), () -> "Missing required Qetcher property de.mklinger.qetcher.client.trustStoreLocation");
        this.trustStorePassword = Optional.ofNullable(propsTool.getString("de.mklinger.qetcher.client.trustStorePassword", null));
        this.trustStoreType = Optional.ofNullable(propsTool.getString("de.mklinger.qetcher.client.trustStoreType", null));
        this.documentConversionTargetPath = propsTool.getSystemProperty(TMP_DIR) + "/liferay/document_conversion";
        this.conversionExtensionsSinglepage = this.getSet("de.mklinger.qetcher.conversion.extensions.singlepage");
        this.conversionExtensionsWhitelistSinglepage = this.getSet("de.mklinger.qetcher.conversion.extensions.whitelist.singlepage");
        this.conversionExtensionsWhitelistMultipage = this.getSet("de.mklinger.qetcher.conversion.extensions.whitelist.multipage");
        this.storePdfAsPreview = propsTool.getBoolean("de.mklinger.qetcher.conversion.storepdfpreview", false);
        this.inlineCssForHtml = propsTool.getBoolean("de.mklinger.qetcher.conversion.html.inlinecss", true);
        this.inlineJsForHtml = propsTool.getBoolean("de.mklinger.qetcher.conversion.html.inlinejs", true);
        this.inlineExternalImagesForHtml = propsTool.getBoolean("de.mklinger.qetcher.conversion.html.inlineexternalimages", true);
        this.inlineInternalImagesForHtml = propsTool.getBoolean("de.mklinger.qetcher.conversion.html.inlineinternalimages", true);
        this.jobWaitTimeoutMillis = propsTool.getLong("de.mklinger.qetcher.job.waittimeoutmillis", TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS));
        this.jobCancelTimeoutMillis = propsTool.getLong("de.mklinger.qetcher.job.canceltimeoutmillis", TimeUnit.MILLISECONDS.convert(2L, TimeUnit.HOURS));
        this.jobDeleteTimeoutMillis = propsTool.getLong("de.mklinger.qetcher.job.deletetimeoutmillis", TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS));
    }

    private Set<String> getSet(String key) {
        PropsTool propsTool = LiferayAbstractionFactorySupplier.getInstance().getPropsTool();
        Object[] arr = propsTool.getArray(key);
        if (arr == null || arr.length == 0) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])arr);
    }

    public String[] getServiceAddresses() {
        return this.serviceAddresses;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public Optional<String> getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Optional<String> getKeyStoreType() {
        return this.keyStoreType;
    }

    public Optional<String> getKeyPassword() {
        return this.keyPassword;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public Optional<String> getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public Optional<String> getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getDocumentConversionTargetPath() {
        return this.documentConversionTargetPath;
    }

    public Set<String> getConversionExtensionsSinglepage() {
        return this.conversionExtensionsSinglepage;
    }

    public Set<String> getConversionExtensionsWhitelistMultipage() {
        return this.conversionExtensionsWhitelistMultipage;
    }

    public Set<String> getConversionExtensionsWhitelistSinglepage() {
        return this.conversionExtensionsWhitelistSinglepage;
    }

    public boolean isStorePdfAsPreview() {
        return this.storePdfAsPreview;
    }

    public boolean isInlineCssForHtml() {
        return this.inlineCssForHtml;
    }

    public boolean isInlineJsForHtml() {
        return this.inlineJsForHtml;
    }

    public boolean isInlineExternalImagesForHtml() {
        return this.inlineExternalImagesForHtml;
    }

    public boolean isInlineInternalImagesForHtml() {
        return this.inlineInternalImagesForHtml;
    }

    public long getJobCancelTimeoutMillis() {
        return this.jobCancelTimeoutMillis;
    }

    public long getJobDeleteTimeoutMillis() {
        return this.jobDeleteTimeoutMillis;
    }

    public long getJobWaitTimeoutMillis() {
        return this.jobWaitTimeoutMillis;
    }
}

