/*
 * Copyright 2013-present mklinger GmbH - http://www.mklinger.de
 *
 * All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of mklinger GmbH and its suppliers, if any.
 * The intellectual and technical concepts contained herein are
 * proprietary to mklinger GmbH and its suppliers and are protected
 * by trade secret or copyright law. Dissemination of this
 * information or reproduction of this material is strictly forbidden
 * unless prior written permission is obtained from mklinger GmbH.
 */
package de.mklinger.qetcher.liferay.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.liferay.abstraction.LiferayException;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetcherLiferayServiceUtil {
	private static volatile QetcherLiferayService service;

	private static QetcherLiferayService getService() {
		if (service == null) {
			synchronized (QetcherLiferayService.class) {
				if (service == null) {
					service = new QetcherLiferayServiceImpl();
				}
			}
		}
		return service;
	}

	//	public static StatusView getStatus() {
	//		return getService().getStatus();
	//	}
	//
	//	public static ServiceVersionView getVersion() {
	//		return getService().getVersion();
	//	}
	//
	//	public static ConvertersView getConverters() {
	//		return getService().getConverters();
	//	}

	public static List<AvailableConversion> getAvailableConversions() {
		return getService().getAvailableConversions();
	}

	//	public static Map<String, Set<String>> getSupportedConversionsExtensions() {
	//		return getService().getSupportedConversionsExtensions();
	//	}

	public static void convert(final InputStream inputStream, final PreviewOutputStreamProvider outputStreamProvider, final String sourceExtension, final String targetExtension, final Map<String, String> targetParameters, final String jobReferer) throws LiferayException, IOException {
		getService().convert(inputStream, outputStreamProvider, sourceExtension, targetExtension, targetParameters, jobReferer);
	}

	public static File convert(final String id, final InputStream inputStream, final String sourceExtension, final String targetExtension) throws LiferayException, IOException {
		return getService().convert(id, inputStream, sourceExtension, targetExtension);
	}

	public static void convert(final InputStream inputStream, final OutputStream outputStream, final String sourceExtension, final String targetExtension, final Map<String, String> targetParameters, final String jobReferer) throws IOException, LiferayException {
		getService().convert(inputStream, outputStream, sourceExtension, targetExtension, targetParameters, jobReferer);
	}

	public static String getFilePath(final String id, final String targetExtension) {
		return getService().getFilePath(id, targetExtension);
	}
}
