package de.mklinger.qetcher.liferay.client.impl;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.mklinger.qetcher.htmlinliner.HtmlElementInliner;
import de.mklinger.qetcher.htmlinliner.InternalResource;
import de.mklinger.qetcher.htmlinliner.QetcherHtmlInlineConfiguration;
import de.mklinger.qetcher.liferay.abstraction.DocumentLibraryFileContents;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactory;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class LiferayHtmlElementInlinerFactory  {
	private static final Logger LOG = LoggerFactory.getLogger(LiferayHtmlElementInlinerFactory.class);

	public static HtmlElementInliner newHtmlElementInliner() {
		return new HtmlElementInliner(new QetcherHtmlInlineConfiguration(), newInternalResourceLoader(), newCookieSupplier());
	}

	private static Function<URI, InternalResource> newInternalResourceLoader() {
		return uri -> {
			final DocumentLibraryFileContents contents = LiferayAbstractionFactory.getInstance().getDLTool().getDocumentLibraryFileContents(uri);
			return newInternalResource(contents);
		};
	}

	private static InternalResource newInternalResource(final DocumentLibraryFileContents contents) {
		return new InternalResource() {
			@Override
			public InputStream getContents() {
				return contents.getContents();
			}

			@Override
			public String getContentType() {
				return contents.getContentType();
			}

			@Override
			public void close() throws Exception {
				contents.close();
			}
		};
	}

	private static Supplier<Collection<de.mklinger.qetcher.htmlinliner.Cookie>> newCookieSupplier() {
		return () -> {
			final HttpServletRequest request = LiferayAbstractionFactory.getInstance().getPortalTool().getHttpServletRequest();
			if (request == null) {
				LOG.debug("No request available");
				return Collections.emptySet();
			}
			final Cookie[] cookies = request.getCookies();
			if (cookies == null || cookies.length == 0) {
				LOG.debug("No cookies");
				return Collections.emptySet();
			}

			return Stream.of(cookies)
					.map(cookie -> newInlinerCookie(cookie))
					.collect(Collectors.toList());
		};
	}

	private static de.mklinger.qetcher.htmlinliner.Cookie newInlinerCookie(final Cookie cookie) {
		return new de.mklinger.qetcher.htmlinliner.Cookie() {
			@Override
			public String getValue() {
				return cookie.getValue();
			}

			@Override
			public String getName() {
				return cookie.getName();
			}
		};
	}
}
