/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl.retry;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherRemoteException;
import de.mklinger.qetcher.client.annotations.VisibleForTesting;
import de.mklinger.qetcher.client.impl.QetcherClientBuilderImpl;
import de.mklinger.qetcher.client.impl.QetcherClientImpl;
import de.mklinger.qetcher.client.impl.lookup.ServiceUriSupplier;
import de.mklinger.qetcher.client.impl.retry.Retrier;
import de.mklinger.qetcher.client.impl.retry.RetryFailedException;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.throwables.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class RetryingQetcherClientImpl
extends QetcherClientImpl {
    private static final int MAX_TRIES = 10;
    private static final int DEFAULT_MAX_WAIT_TIME_MILLIS = 1000;
    private final long maxWaitTimeMillis;

    public RetryingQetcherClientImpl(QetcherClientBuilderImpl builder, ServiceUriSupplier serviceUriSupplier) {
        this(builder, serviceUriSupplier, 1000L);
    }

    @VisibleForTesting
    protected RetryingQetcherClientImpl(QetcherClientBuilderImpl builder, ServiceUriSupplier serviceUriSupplier, long maxWaitTimeMillis) {
        super(builder, serviceUriSupplier);
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    @Override
    public CompletableFuture<ConversionFile> uploadFile(InputConversionFile inputFile) {
        return this.doWithRetry(() -> super.uploadFile(inputFile));
    }

    @Override
    public CompletableFuture<ConversionFile> getFile(String fileId) {
        return this.doWithRetry(() -> super.getFile(fileId));
    }

    @Override
    public CompletableFuture<List<ConversionFile>> getFiles() {
        return this.doWithRetry(() -> super.getFiles());
    }

    @Override
    public CompletableFuture<Void> deleteFile(String fileId) {
        return this.doWithRetry(() -> super.deleteFile(fileId));
    }

    @Override
    public CompletableFuture<Path> downloadAsFile(String fileId, Path file, OpenOption ... openOptions) {
        return this.doWithRetry(() -> super.downloadAsFile(fileId, file, openOptions));
    }

    @Override
    public CompletableFuture<Job> createJob(InputJob inputJob) {
        return this.doWithRetry(() -> super.createJob(inputJob));
    }

    @Override
    public CompletableFuture<Job> getJob(String jobId) {
        return this.doWithRetry(() -> super.getJob(jobId));
    }

    @Override
    public CompletableFuture<List<Job>> getJobs() {
        return this.doWithRetry(() -> super.getJobs());
    }

    @Override
    public CompletableFuture<Void> deleteJob(String jobId) {
        return this.doWithRetry(() -> super.deleteJob(jobId));
    }

    @Override
    public CompletableFuture<List<AvailableConversion>> getAvailableConversions() {
        return this.doWithRetry(() -> super.getAvailableConversions());
    }

    @Override
    public CompletableFuture<List<AvailableNode>> getAvailableNodes() {
        return this.doWithRetry(() -> super.getAvailableNodes());
    }

    @Override
    public CompletableFuture<ConversionFile> getFile(ConversionFile file) {
        return this.doWithRetry(() -> super.getFile(file));
    }

    @Override
    public CompletableFuture<Void> deleteFile(ConversionFile file) {
        return this.doWithRetry(() -> super.deleteFile(file));
    }

    @Override
    public CompletableFuture<Path> downloadAsFile(String fileId, Path file) {
        return this.doWithRetry(() -> super.downloadAsFile(fileId, file));
    }

    @Override
    public CompletableFuture<File> downloadAsFile(String fileId, File file) {
        return this.doWithRetry(() -> super.downloadAsFile(fileId, file));
    }

    @Override
    public CompletableFuture<Path> downloadAsTempFile(String fileId) {
        return this.doWithRetry(() -> super.downloadAsTempFile(fileId));
    }

    @Override
    public CompletableFuture<Path> downloadAsTempFile(String fileId, Path dir) {
        return this.doWithRetry(() -> super.downloadAsTempFile(fileId, dir));
    }

    @Override
    public CompletableFuture<Job> getJob(Job job) {
        return this.doWithRetry(() -> super.getJob(job));
    }

    @Override
    public CompletableFuture<Void> deleteJob(Job job) {
        return this.doWithRetry(() -> super.deleteJob(job));
    }

    @Override
    public CompletableFuture<Job> getJobDone(Job job) {
        return this.doWithRetry(() -> super.getJobDone(job));
    }

    @Override
    public CompletableFuture<Job> getJobDone(String jobId) {
        return this.doWithRetry(() -> super.getJobDone(jobId));
    }

    private <T> CompletableFuture<T> doWithRetry(Supplier<CompletableFuture<T>> action) {
        CompletableFuture cf = new CompletableFuture();
        new Retrier(cf, action, this::isRetryCandidate, 10, this.maxWaitTimeMillis).run();
        return cf;
    }

    private boolean isRetryCandidate(Throwable error) {
        return !this.isRetryFailedException(error) && (Throwables.firstCause(error, IOException.class).isPresent() || Throwables.firstCause(error, QetcherRemoteException.class).map(QetcherRemoteException::getStatusCode).map(statusCode -> statusCode == 404 || statusCode == 417).orElse(false) != false);
    }

    private boolean isRetryFailedException(Throwable error) {
        return Throwables.firstCause(error, RetryFailedException.class).isPresent();
    }
}

