/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient;

import de.mklinger.qetcher.client.httpclient.HttpHeaders;
import de.mklinger.qetcher.client.httpclient.internal.HttpRequestBuilderImpl;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;

public interface HttpRequest {
    public Optional<BodyProvider> bodyProvider();

    public String method();

    public Optional<Duration> timeout();

    public URI uri();

    public HttpHeaders headers();

    public static Builder newBuilder(URI uri) {
        return new HttpRequestBuilderImpl(uri);
    }

    public static Builder newBuilder() {
        return new HttpRequestBuilderImpl();
    }

    public static interface Builder {
        public Builder uri(URI var1);

        public Builder header(String var1, String var2);

        public Builder headers(String ... var1);

        public Builder timeout(Duration var1);

        public Builder setHeader(String var1, String var2);

        public Builder GET();

        public Builder POST(BodyProvider var1);

        public Builder PUT(BodyProvider var1);

        public Builder DELETE(BodyProvider var1);

        public Builder method(String var1, BodyProvider var2);

        public HttpRequest build();
    }

    public static interface BodyProvider {
    }
}

