/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.htmlinliner;

import de.mklinger.qetcher.htmlinliner.Cookie;
import de.mklinger.qetcher.htmlinliner.InternalResource;
import de.mklinger.qetcher.htmlinliner.QetcherHtmlInlineConfiguration;
import de.mklinger.qetcher.htmlinliner.ResourceLoader;
import de.mklinger.qetcher.htmlinliner.ResourceLoaderImpl;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlElementInliner
implements Closeable {
    private static final Pattern CSS_IMPORT_PATTERN = Pattern.compile("@import\\s+url\\s*\\(\\s*(.*?)\\s*\\)\\s*;?", 34);
    private static final Logger LOG = LoggerFactory.getLogger(HtmlElementInliner.class);
    private final QetcherHtmlInlineConfiguration configuration;
    private final Function<URI, InternalResource> internalResourceLoader;
    private final ResourceLoader resourceLoader;

    public HtmlElementInliner(QetcherHtmlInlineConfiguration configuration, Function<URI, InternalResource> internalResourceLoader, Supplier<Collection<Cookie>> cookieSupplier) {
        this.configuration = configuration;
        this.internalResourceLoader = internalResourceLoader;
        this.resourceLoader = new ResourceLoaderImpl(cookieSupplier);
    }

    public byte[] inline(InputStream htmlInputStream, String baseUri) throws IOException {
        Document htmlDocument = Jsoup.parse((InputStream)htmlInputStream, null, (String)baseUri);
        if (this.configuration.isInlineExternalImagesForHtml() || this.configuration.isInlineInternalImagesForHtml()) {
            Elements imgs = htmlDocument.getElementsByTag("img");
            for (Element img : imgs) {
                try {
                    String url = img.absUrl("src");
                    if (url == null) continue;
                    LOG.debug("Trying to inline {}", (Object)url);
                    Optional<String> optionalNewImgSrc = this.getNewImgSrc(url, baseUri);
                    if (!optionalNewImgSrc.isPresent()) continue;
                    String newImgSrc = optionalNewImgSrc.get();
                    LOG.debug("Inlining url {}: {} inlined chars", (Object)url, (Object)newImgSrc.length());
                    img.attr("src", newImgSrc);
                }
                catch (Exception e) {
                    LOG.info("Error inlining image: {}", (Object)e.toString());
                }
            }
        }
        if (this.configuration.isInlineCssForHtml()) {
            Elements links = htmlDocument.getElementsByTag("link");
            for (Object link : links) {
                try {
                    String href;
                    String rel = link.attr("rel");
                    if (!"stylesheet".equalsIgnoreCase(rel) || (href = link.absUrl("href")) == null || href.isEmpty()) continue;
                    LOG.debug("Trying to inline {}", (Object)href);
                    Node newCssLink = this.getNewCssLink((Element)link, baseUri);
                    if (newCssLink == null) continue;
                    LOG.debug("Inlining css link {}", link);
                    link.replaceWith(newCssLink);
                }
                catch (Exception e) {
                    LOG.info("Error inlining link css: {}", (Object)e.toString());
                }
            }
            Elements styles = htmlDocument.getElementsByTag("style");
            for (Element style : styles) {
                try {
                    String newCss;
                    String css = style.html();
                    if (css == null || css.trim().isEmpty() || (newCss = this.resolveCss(baseUri, css)) == null) continue;
                    LOG.debug("Inlining css: {} inlined chars", (Object)newCss.length());
                    DataNode data = DataNode.createFromEncoded((String)newCss, (String)baseUri);
                    style.html("");
                    style.appendChild((Node)data);
                }
                catch (Exception e) {
                    LOG.info("Error inlining style css: {}", (Object)e.toString());
                }
            }
        }
        if (this.configuration.isInlineJsForHtml()) {
            Elements scripts = htmlDocument.getElementsByTag("script");
            for (Element script : scripts) {
                try {
                    String src = script.absUrl("src");
                    if (src == null || src.isEmpty()) continue;
                    LOG.debug("Trying to inline {}", (Object)src);
                    Node newScript = this.getNewScript(script, baseUri);
                    if (newScript == null) continue;
                    LOG.debug("Inlining js url {}", (Object)src);
                    script.replaceWith(newScript);
                }
                catch (Exception e) {
                    LOG.info("Error inlining script: {}", (Object)e.toString());
                }
            }
        }
        byte[] htmlBytes = htmlDocument.outerHtml().getBytes(htmlDocument.outputSettings().charset());
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTML after inlining:\n{}", (Object)new String(htmlBytes, htmlDocument.outputSettings().charset()));
        }
        return htmlBytes;
    }

    private String resolveCss(String baseUri, String css) throws URISyntaxException {
        Matcher matcher = CSS_IMPORT_PATTERN.matcher(css);
        StringBuilder newCss = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            Optional<String> optionalContents;
            int start = matcher.start();
            if (start > 0) {
                newCss.append(css, lastEnd, start);
            }
            lastEnd = matcher.end();
            String url = matcher.group(1);
            if (url.length() > 2 && (url.startsWith("\"") && url.endsWith("\"") || url.startsWith("'") && url.endsWith("'"))) {
                url = url.substring(1, url.length() - 1);
            }
            boolean replaced = false;
            String absoluteUrl = this.getAbsoluteUrl(baseUri, url);
            if (absoluteUrl != null && (optionalContents = this.resourceLoader.getContents(new URI(absoluteUrl), new URI(baseUri))).isPresent()) {
                String contents = optionalContents.get();
                String resolvedContents = this.resolveCss(absoluteUrl, contents);
                if (resolvedContents != null) {
                    newCss.append(resolvedContents);
                } else {
                    newCss.append(contents);
                }
                replaced = true;
            }
            if (replaced) continue;
            newCss.append(matcher.group());
        }
        if (lastEnd > 0) {
            if (lastEnd < css.length()) {
                newCss.append(css, lastEnd, css.length());
            }
            return newCss.toString();
        }
        return css;
    }

    private String getAbsoluteUrl(String baseUri, String relUrl) {
        try {
            URL base;
            try {
                base = new URL(baseUri);
            }
            catch (MalformedURLException e) {
                URL abs = new URL(relUrl);
                return abs.toExternalForm();
            }
            if (relUrl.startsWith("?")) {
                relUrl = base.getPath() + relUrl;
            }
            URL abs = new URL(base, relUrl);
            return abs.toExternalForm();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private Node getNewScript(Element script, String baseUri) throws URISyntaxException {
        Optional<String> optionalJs = this.resourceLoader.getContents(new URI(script.absUrl("src")), new URI(baseUri));
        if (!optionalJs.isPresent()) {
            return null;
        }
        String js = optionalJs.get();
        String html = "<script>\n/* <![CDATA[ */\n" + js + "\n/* ]]> */\n</script>";
        Document doc = Jsoup.parse((String)html);
        Element scriptNode = doc.select("script").first();
        this.copyType((Node)script, (Node)scriptNode);
        return scriptNode;
    }

    private Node getNewCssLink(Element link, String baseUri) throws URISyntaxException {
        String cssUri = link.absUrl("href");
        Optional<String> optionalCss = this.resourceLoader.getContents(new URI(cssUri), new URI(baseUri));
        if (!optionalCss.isPresent()) {
            return null;
        }
        String css = optionalCss.get();
        css = this.resolveCss(cssUri, css);
        String html = "<style>\n/* <![CDATA[ */\n" + css + "\n/* ]]> */\n</style>";
        Document doc = Jsoup.parse((String)html);
        Element styleNode = doc.select("style").first();
        this.copyType((Node)link, (Node)styleNode);
        return styleNode;
    }

    private void copyType(Node link, Node newLink) {
        String type = link.attr("type");
        if (type != null) {
            newLink.attr("type", type);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> getNewImgSrc(String url, String baseUri) {
        if (this.configuration.isInlineInternalImagesForHtml()) {
            try (InternalResource localContents = this.internalResourceLoader.apply(new URI(url));){
                if (localContents != null) {
                    Optional<String> optional = Optional.of(this.resourceLoader.getInlineImgSrc(localContents.getContentType(), localContents.getContents()));
                    return optional;
                }
            }
            catch (Exception e) {
                LOG.info("Error fetching local contents for inline image: {}: {}", (Object)url, (Object)e.getMessage());
            }
        }
        if (!this.configuration.isInlineExternalImagesForHtml()) return Optional.empty();
        try {
            return this.resourceLoader.getExternalInlineImgSrc(new URI(url), new URI(baseUri));
        }
        catch (Exception e) {
            LOG.info("Error fetching external contents for inline image: {}: {}", (Object)url, (Object)e.getMessage());
        }
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        this.resourceLoader.close();
    }
}

