/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.liferay.abstraction.FileVersion;
import de.mklinger.qetcher.liferay.client.impl.OutputStreamProvider;
import de.mklinger.qetcher.liferay.client.impl.PreviewOutputStream;
import de.mklinger.qetcher.liferay.client.impl.PreviewProcessorBridge;
import java.io.IOException;
import java.io.OutputStream;

public class PreviewOutputStreamProvider
implements OutputStreamProvider {
    private final PreviewProcessorBridge processor;
    private final FileVersion fileVersion;
    private final boolean storeThumbnail;
    private final boolean storePreview;
    private int page = 0;

    public PreviewOutputStreamProvider(FileVersion fileVersion, boolean storeThumbnail, boolean storePreview, PreviewProcessorBridge processor) {
        this.fileVersion = fileVersion;
        this.storeThumbnail = storeThumbnail;
        this.storePreview = storePreview;
        this.processor = processor;
    }

    @Override
    public OutputStream getOutputStream(Job job, ConversionFile resultFile) {
        ++this.page;
        try {
            return new PreviewOutputStream(this.fileVersion, this.page, this.storeThumbnail && this.page == 1, this.storePreview, this.processor);
        }
        catch (IOException e) {
            throw new QetcherClientException("Error processing preview file", (Throwable)e);
        }
    }
}

