/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessor;
import de.mklinger.qetcher.liferay.abstraction.FileVersion;
import de.mklinger.qetcher.liferay.abstraction.LiferayException;
import de.mklinger.qetcher.liferay.client.impl.LiferayClientConfiguration;
import de.mklinger.qetcher.liferay.client.impl.PreviewOutputStreamProvider;
import de.mklinger.qetcher.liferay.client.impl.PreviewProcessorBridge;
import de.mklinger.qetcher.liferay.client.impl.QetcherLiferayServiceUtil;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactorySupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFProcessorImpl
extends DLPreviewableProcessor
implements PDFProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PDFProcessorImpl.class);
    private static Log _log = LogFactoryUtil.getLog(PDFProcessorImpl.class);
    private final List<Long> _fileVersionIds = new Vector<Long>();

    public void afterPropertiesSet() throws Exception {
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
        FileUtil.mkdirs((String)THUMBNAIL_TMP_PATH);
    }

    public void generateImages(com.liferay.portal.kernel.repository.model.FileVersion sourceFileVersion, com.liferay.portal.kernel.repository.model.FileVersion destinationFileVersion) throws Exception {
        this._generateImages(sourceFileVersion, destinationFileVersion);
    }

    public InputStream getPreviewAsStream(com.liferay.portal.kernel.repository.model.FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, index, "png");
    }

    public int getPreviewFileCount(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) {
        try {
            return this.doGetPreviewFileCount(fileVersion);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    public long getPreviewFileSize(com.liferay.portal.kernel.repository.model.FileVersion fileVersion, int index) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, index);
    }

    public InputStream getThumbnailAsStream(com.liferay.portal.kernel.repository.model.FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailAsStream(fileVersion, index);
    }

    public long getThumbnailFileSize(com.liferay.portal.kernel.repository.model.FileVersion fileVersion, int index) throws Exception {
        return this.doGetThumbnailFileSize(fileVersion, index);
    }

    public boolean hasImages(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) {
        boolean hasImages = false;
        try {
            hasImages = this._hasImages(fileVersion);
            if (!hasImages && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return hasImages;
    }

    public boolean isDocumentSupported(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isDocumentSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isSupported(String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return false;
        }
        if (mimeType.equals("application/pdf") || mimeType.equals("application/x-pdf")) {
            return true;
        }
        if (DocumentConversionUtil.isEnabled()) {
            Set extensions = MimeTypesUtil.getExtensions((String)mimeType);
            for (String extension : extensions) {
                String[] targetExtensions;
                extension = extension.substring(1);
                for (String targetExtension : targetExtensions = DocumentConversionUtil.getConversions((String)extension)) {
                    if (!"pdf".equals(targetExtension)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void trigger(com.liferay.portal.kernel.repository.model.FileVersion sourceFileVersion, com.liferay.portal.kernel.repository.model.FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void copyPreviews(com.liferay.portal.kernel.repository.model.FileVersion sourceFileVersion, com.liferay.portal.kernel.repository.model.FileVersion destinationFileVersion) {
        if (!PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            return;
        }
        try {
            if (this.hasPreview(sourceFileVersion) && !this.hasPreview(destinationFileVersion)) {
                int count = this.getPreviewFileCount(sourceFileVersion);
                for (int i = 0; i < count; ++i) {
                    String previewFilePath = this.getPreviewFilePath(destinationFileVersion, i + 1);
                    InputStream is = this.doGetPreviewAsStream(sourceFileVersion, i + 1, "png");
                    this.addFileToStore(destinationFileVersion.getCompanyId(), "document_preview/", previewFilePath, is);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportThumbnails(portletDataContext, fileEntry, fileEntryElement, "pdf");
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importThumbnails(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf");
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        com.liferay.portal.kernel.repository.model.FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this._hasImages(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            int previewFileCount = this.getPreviewFileCount(fileVersion);
            fileEntryElement.addAttribute("bin-path-pdf-preview-count", String.valueOf(previewFileCount));
            for (int i = 0; i < previewFileCount; ++i) {
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "pdf", "png", i);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) {
        return "png";
    }

    protected String getThumbnailType(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) {
        return "png";
    }

    protected boolean hasPreview(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) throws Exception {
        return this.hasPreview(fileVersion, null);
    }

    protected boolean hasPreview(com.liferay.portal.kernel.repository.model.FileVersion fileVersion, String type) throws Exception {
        String previewFilePath = this.getPreviewFilePath(fileVersion, 1);
        return DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)previewFilePath);
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        int previewFileCount = GetterUtil.getInteger((String)fileEntryElement.attributeValue("bin-path-pdf-preview-count"));
        for (int i = 0; i < previewFileCount; ++i) {
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "pdf", "png", i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _generateImages(com.liferay.portal.kernel.repository.model.FileVersion sourceFileVersion, com.liferay.portal.kernel.repository.model.FileVersion destinationFileVersion) throws Exception {
        block14: {
            inputStream = null;
            if (sourceFileVersion != null) {
                this.copy(sourceFileVersion, destinationFileVersion);
            }
            ** GOTO lbl-1000
            {
                block13: {
                    catch (NoSuchFileEntryException var4_5) {
                        return;
                        catch (Throwable var7_11) {
                            throw var7_11;
                        }
                    }
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (!this._hasImages(destinationFileVersion)) break block13;
                    }
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                    return;
                }
                extension = destinationFileVersion.getExtension();
                if (!extension.equals("pdf")) break block14;
                if (destinationFileVersion instanceof LiferayFileVersion) {
                    try {
                        liferayFileVersion = (LiferayFileVersion)destinationFileVersion;
                        file = liferayFileVersion.getFile(false);
                        this._generateImages(destinationFileVersion, file);
                    }
                    catch (UnsupportedOperationException liferayFileVersion) {}
                    ** try [egrp 4[TRYBLOCK] [4, 8 : 138->247)] { 
                }
lbl31:
                // 3 sources

                inputStream = destinationFileVersion.getContentStream(false);
                this._generateImages(destinationFileVersion, inputStream);
                return;
lbl34:
                // 1 sources

                finally {
                    StreamUtil.cleanUp(inputStream);
                    this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                }
            }
            StreamUtil.cleanUp((InputStream)inputStream);
            this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
            return;
        }
        if (DocumentConversionUtil.isEnabled() == false) return;
        inputStream = destinationFileVersion.getContentStream(false);
        tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
        file = DocumentConversionUtil.convert((String)tempFileId, (InputStream)inputStream, (String)extension, (String)"pdf");
        if (LiferayClientConfiguration.getInstance().isStorePdfAsPreview()) {
            PDFProcessorImpl.LOG.info("Adding preview PDF to store");
            this.addFileToStore(destinationFileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(destinationFileVersion, "pdf"), file);
        }
        this._generateImages(destinationFileVersion, file);
    }

    protected void addFileToStore(long companyId, String dirName, String filePath, File srcFile) throws PortalException, SystemException {
        try {
            DLStoreUtil.deleteFile((long)companyId, (long)0L, (String)filePath);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        super.addFileToStore(companyId, dirName, filePath, srcFile);
    }

    protected void addFileToStore(long companyId, String dirName, String filePath, InputStream is) throws PortalException, SystemException {
        try {
            DLStoreUtil.deleteFile((long)companyId, (long)0L, (String)filePath);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        super.addFileToStore(companyId, dirName, filePath, is);
    }

    private void _generateImages(com.liferay.portal.kernel.repository.model.FileVersion fileVersion, File file) throws Exception {
        this._generateImages(fileVersion, new FileInputStream(file));
    }

    private void _generateImages(com.liferay.portal.kernel.repository.model.FileVersion fileVersion, InputStream inputStream) throws Exception {
        boolean storePreview = this._isGeneratePreview(fileVersion);
        boolean storeThumbnail = this._isGenerateThumbnail(fileVersion);
        HashMap<String, String> targetParameters = new HashMap<String, String>();
        targetParameters.put("resolution", String.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_DPI));
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT != 0) {
            targetParameters.put("width", String.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH));
            targetParameters.put("height", String.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_HEIGHT));
        } else {
            targetParameters.put("width", String.valueOf(PropsValues.DL_FILE_ENTRY_PREVIEW_DOCUMENT_MAX_WIDTH));
        }
        if (storeThumbnail && !storePreview) {
            targetParameters.put("pages", "1");
        }
        FileVersion wrappedLiferayFileVersion = LiferayAbstractionFactorySupplier.getInstance().getDLTool().wrapLiferayFileVersion((Object)fileVersion);
        PreviewOutputStreamProvider outputStreamProvider = new PreviewOutputStreamProvider(wrappedLiferayFileVersion, storeThumbnail, storePreview, new PreviewProcessorBridgeImpl());
        QetcherLiferayServiceUtil.convert(inputStream, outputStreamProvider, "pdf", "png", targetParameters, this.getReferer(fileVersion));
    }

    private String getReferer(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) {
        return "companyId=" + fileVersion.getCompanyId() + ",fileEntryId=" + fileVersion.getFileEntryId();
    }

    private boolean _hasImages(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) throws Exception {
        return !this._isGeneratePreview(fileVersion) && this.hasThumbnails(fileVersion);
    }

    private boolean _isGeneratePreview(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) throws Exception {
        if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            if (!DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)this.getPreviewFilePath(fileVersion, 1))) {
                return true;
            }
            if (LiferayClientConfiguration.getInstance().isStorePdfAsPreview() && !"pdf".equals(fileVersion.getExtension()) && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)this.getPreviewFilePath(fileVersion, "pdf"))) {
                return true;
            }
        }
        return false;
    }

    private boolean _isGenerateThumbnail(com.liferay.portal.kernel.repository.model.FileVersion fileVersion) throws Exception {
        String thumbnailFilePath = this.getThumbnailFilePath(fileVersion, 0);
        return PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED && !DLStoreUtil.hasFile((long)fileVersion.getCompanyId(), (long)0L, (String)thumbnailFilePath);
    }

    private void _queueGeneration(com.liferay.portal.kernel.repository.model.FileVersion sourceFileVersion, com.liferay.portal.kernel.repository.model.FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId())) {
            return;
        }
        boolean generateImages = false;
        String extension = destinationFileVersion.getExtension();
        if (extension.equals("pdf")) {
            generateImages = true;
        } else if (DocumentConversionUtil.isEnabled()) {
            String[] conversions;
            for (String conversion : conversions = DocumentConversionUtil.getConversions((String)extension)) {
                if (!"pdf".equals(conversion)) continue;
                generateImages = true;
                break;
            }
        }
        if (generateImages) {
            this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
            this.sendGenerationMessage("liferay/document_library_pdf_processor", sourceFileVersion, destinationFileVersion);
        }
    }

    private class PreviewProcessorBridgeImpl
    implements PreviewProcessorBridge {
        private PreviewProcessorBridgeImpl() {
        }

        @Override
        public File getPreviewTempFile(String id, int index) {
            return PDFProcessorImpl.this.getPreviewTempFile(id, index);
        }

        @Override
        public void storeThumbnailImages(FileVersion fileVersion, File file) throws Exception {
            PDFProcessorImpl.this.storeThumbnailImages((com.liferay.portal.kernel.repository.model.FileVersion)fileVersion.unwrap(), file);
        }

        @Override
        public String getPreviewFilePath(FileVersion fileVersion, int index) {
            return PDFProcessorImpl.this.getPreviewFilePath((com.liferay.portal.kernel.repository.model.FileVersion)fileVersion.unwrap(), index);
        }

        @Override
        public void addFileToStore(long companyId, String dirName, String filePath, File srcFile) throws LiferayException {
            try {
                PDFProcessorImpl.this.addFileToStore(companyId, dirName, filePath, srcFile);
            }
            catch (PortalException | SystemException e) {
                throw new LiferayException(e);
            }
        }
    }
}

