package com.liferay.portal.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.tika.metadata.Metadata;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.xml.Element;

import de.mklinger.qetcher.liferay.client.impl.QetcherRawMetadataProcessor;

public class TikaRawMetadataProcessor extends BaseRawMetadataProcessor {
	private final QetcherRawMetadataProcessor qetcherRawMetadataProcessor;

	public TikaRawMetadataProcessor() {
		this(new QetcherRawMetadataProcessor());
	}

	//VisibleForTesting
	protected TikaRawMetadataProcessor(final QetcherRawMetadataProcessor qetcherRawMetadataProcessor) {
		this.qetcherRawMetadataProcessor = qetcherRawMetadataProcessor;
	}

	// Required for Spring config compatibility
	public void setParser(final Object unused) {
		// Do nothing
	}

	@Override
	public void exportGeneratedFiles(final PortletDataContext portletDataContext, final FileEntry fileEntry, final Element fileEntryElement) throws Exception {
		// Do nothing
	}

	@Override
	public void importGeneratedFiles(final PortletDataContext portletDataContext, final FileEntry fileEntry, final FileEntry importedFileEntry, final Element fileEntryElement) throws Exception {
		// Do nothing
	}

	@Override
	protected Metadata extractMetadata(final String extension, final String mimeType, final File file) throws PortalException, SystemException {
		try (InputStream in = new FileInputStream(file)) {
			return extractMetadata(extension, mimeType, in);
		} catch (final IOException e) {
			throw new SystemException(e);
		}
	}

	@Override
	protected Metadata extractMetadata(final String extension, final String mimeType, final InputStream inputStream) throws PortalException, SystemException {
		final Metadata metadata = new Metadata();

		qetcherRawMetadataProcessor.extractMetadata(inputStream, "liferay-metadata-" + extension)
		.entrySet()
		.forEach(e -> metadata.set(e.getKey(), e.getValue()));

		return metadata;
	}
}
