/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.abstraction;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.DocumentConversionUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessorUtil;
import de.mklinger.qetcher.liferay.abstraction.DLTool;
import de.mklinger.qetcher.liferay.abstraction.DocumentLibraryFileContents;
import de.mklinger.qetcher.liferay.abstraction.Image;
import de.mklinger.qetcher.liferay.abstraction.LiferayException;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactorySupplier;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayFileVersionWrapper;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLToolImpl
implements DLTool {
    private static final Logger LOG = LoggerFactory.getLogger(DLToolImpl.class);

    public String getPreviewPath() {
        return "document_preview/";
    }

    public DocumentLibraryFileContents getDocumentLibraryFileContents(URI uri) {
        try {
            Long companyId = CompanyThreadLocal.getCompanyId();
            if (companyId == null || companyId <= 0L) {
                return null;
            }
            Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
            if (!uri.getHost().equals(company.getVirtualHostname())) {
                return null;
            }
            if (!uri.getPath().startsWith("/documents/") && !uri.getPath().startsWith("/image/")) {
                return null;
            }
            return this.doGetDocumentLibraryFileContents(uri);
        }
        catch (Exception e) {
            LOG.warn("Error getting document library file contents", (Throwable)e);
            return null;
        }
    }

    private DocumentLibraryFileContents doGetDocumentLibraryFileContents(URI uri) throws Exception {
        LOG.debug("Current user: {} - '{}'", (Object)PrincipalThreadLocal.getUserId(), (Object)PrincipalThreadLocal.getName());
        LOG.debug("Current permission checker: {}", (Object)PermissionThreadLocal.getPermissionChecker());
        String[] pathArray = this.getPathArray(uri);
        if (pathArray == null) {
            return null;
        }
        Map<String, String> parameters = this.getParameters(uri);
        LOG.debug("Parameters: {}", parameters);
        if (Validator.isNumber((String)pathArray[0])) {
            return this.getDocumentLibraryFileContents(pathArray, parameters);
        }
        Image image = this.getImage(true, parameters, pathArray);
        if (image != null) {
            return this.getImageContents(image, parameters);
        }
        return null;
    }

    protected Map<String, String> getParameters(URI uri) {
        String query = uri.getRawQuery();
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String keyValuePair = st.nextToken();
            int idx = keyValuePair.indexOf(61);
            if (idx == 0) continue;
            if (idx == -1) {
                parameters.put(this.urlDecode(keyValuePair), "");
                continue;
            }
            if (idx == keyValuePair.length() - 1) {
                parameters.put(this.urlDecode(keyValuePair.substring(0, idx)), "");
                continue;
            }
            parameters.put(this.urlDecode(keyValuePair.substring(0, idx)), this.urlDecode(keyValuePair.substring(idx + 1)));
        }
        return parameters;
    }

    private String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String[] getPathArray(URI uri) {
        StringTokenizer st = new StringTokenizer(uri.getPath(), "/");
        int count = st.countTokens();
        if (count < 2) {
            return null;
        }
        st.nextToken();
        String[] pathArray = new String[count - 1];
        for (int i = 0; i < count - 1; ++i) {
            pathArray[i] = st.nextToken();
        }
        return pathArray;
    }

    private DocumentLibraryFileContents getDocumentLibraryFileContents(String[] pathArray, Map<String, String> parameters) throws Exception {
        FileEntry fileEntry = this.getFileEntry(pathArray);
        if (fileEntry == null) {
            throw new NoSuchFileEntryException();
        }
        String version = parameters.get("version");
        if (Validator.isNull((String)version) && Validator.isNotNull((String)fileEntry.getVersion())) {
            version = fileEntry.getVersion();
        }
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        if (GetterUtil.getInteger((String)parameters.get("height")) > 0 || GetterUtil.getInteger((String)parameters.get("width")) > 0) {
            Image image;
            try (InputStream inputStream = fileVersion.getContentStream(true);){
                image = LiferayAbstractionFactorySupplier.getInstance().getImageTool().getImage(inputStream);
            }
            return this.getImageContents(image, parameters);
        }
        String fileName = fileVersion.getTitle();
        String extension = fileVersion.getExtension();
        if (Validator.isNotNull((String)extension) && !fileName.endsWith("." + extension)) {
            fileName = fileName + "." + extension;
        }
        boolean converted = false;
        String targetExtension = GetterUtil.getString((String)parameters.get("targetExtension"));
        int imageThumbnail = GetterUtil.getInteger((String)parameters.get("imageThumbnail"));
        int documentThumbnail = GetterUtil.getInteger((String)parameters.get("documentThumbnail"));
        int previewFileIndex = GetterUtil.getInteger((String)parameters.get("previewFileIndex"));
        boolean imagePreview = GetterUtil.getBoolean((String)parameters.get("imagePreview"));
        InputStream inputStream = null;
        long contentLength = 0L;
        if (imageThumbnail > 0 && imageThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(ImageProcessorUtil.getThumbnailType((FileVersion)fileVersion));
            int thumbnailIndex = imageThumbnail - 1;
            inputStream = ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = ImageProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (documentThumbnail > 0 && documentThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("png");
            int thumbnailIndex = documentThumbnail - 1;
            inputStream = PDFProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = PDFProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (previewFileIndex > 0) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("png");
            inputStream = PDFProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (int)previewFileIndex);
            contentLength = PDFProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (int)previewFileIndex);
            converted = true;
        } else if (imagePreview) {
            String type = ImageProcessorUtil.getPreviewType((FileVersion)fileVersion);
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(type);
            inputStream = ImageProcessorUtil.getPreviewAsStream((FileVersion)fileVersion);
            contentLength = ImageProcessorUtil.getPreviewFileSize((FileVersion)fileVersion);
            converted = true;
        } else {
            String tempFileId;
            File convertedFile;
            inputStream = fileVersion.getContentStream(true);
            contentLength = fileVersion.getSize();
            if (Validator.isNotNull((String)targetExtension) && (convertedFile = DocumentConversionUtil.convert((String)(tempFileId = DLUtil.getTempFileId((long)fileEntry.getFileEntryId(), (String)version)), (InputStream)inputStream, (String)extension, (String)targetExtension)) != null) {
                fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(targetExtension);
                inputStream = new FileInputStream(convertedFile);
                contentLength = convertedFile.length();
                converted = true;
            }
        }
        String contentType = null;
        contentType = converted ? MimeTypesUtil.getContentType((String)fileName) : fileVersion.getMimeType();
        return new DocumentLibraryFileContents(fileName, inputStream, contentLength, contentType);
    }

    private FileEntry getFileEntry(String[] pathArray) throws Exception {
        if (pathArray.length == 1) {
            long dlFileShortcutId = GetterUtil.getLong((String)pathArray[0]);
            DLFileShortcut dlFileShortcut = DLAppServiceUtil.getFileShortcut((long)dlFileShortcutId);
            return DLAppServiceUtil.getFileEntry((long)dlFileShortcut.getToFileEntryId());
        }
        if (pathArray.length == 2) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            return DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)pathArray[1], (long)groupId);
        }
        if (pathArray.length == 3) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            long folderId = GetterUtil.getLong((String)pathArray[1]);
            String fileName = HttpUtil.decodeURL((String)pathArray[2]);
            if (fileName.contains("?")) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            return DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        long groupId = GetterUtil.getLong((String)pathArray[0]);
        String uuid = pathArray[3];
        return DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
    }

    private DocumentLibraryFileContents getImageContents(Image image, Map<String, String> parameters) {
        if (image == null) {
            return null;
        }
        String contentType = null;
        String type = image.getType();
        if (!type.equals("na")) {
            contentType = MimeTypesUtil.getContentType((String)("A." + type));
        }
        try {
            byte[] bytes = this.getImageBytes(image, parameters);
            return new DocumentLibraryFileContents(null, (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, contentType);
        }
        catch (Exception e) {
            LOG.warn("Error getting image bytes", (Throwable)e);
            return null;
        }
    }

    private byte[] getImageBytes(Image image, Map<String, String> parameters) {
        try {
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"image.auto.scale"))) {
                return image.getTextObj();
            }
            ImageBag imageBag = null;
            if (image.getImageId() == 0L) {
                imageBag = ImageToolUtil.read((byte[])image.getTextObj());
                RenderedImage renderedImage = imageBag.getRenderedImage();
                image.setHeight(renderedImage.getHeight());
                image.setWidth(renderedImage.getWidth());
            }
            int height = GetterUtil.getInteger((String)parameters.get("height"), (int)image.getHeight());
            int width = GetterUtil.getInteger((String)parameters.get("width"), (int)image.getWidth());
            if (height >= image.getHeight() && width >= image.getWidth()) {
                return image.getTextObj();
            }
            if (image.getImageId() != 0L) {
                imageBag = ImageToolUtil.read((byte[])image.getTextObj());
                RenderedImage renderedImage = ImageToolUtil.scale((RenderedImage)imageBag.getRenderedImage(), (int)height, (int)width);
                return ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
            }
        }
        catch (Exception e) {
            LOG.warn("Error scaling image {}", (Object)image.getImageId(), (Object)e);
        }
        return image.getTextObj();
    }

    private Image getImage(boolean getDefault, Map<String, String> parameters, String[] pathArray) throws LiferayException {
        Image image = null;
        long imageId = this.getImageId(parameters);
        if (imageId > 0L) {
            image = LiferayAbstractionFactorySupplier.getInstance().getImageTool().getImage(imageId);
            if (pathArray != null && pathArray.length > 0 && ("user_female_portrait".equals(pathArray[0]) || "user_male_portrait".equals(pathArray[0]) || "user_portrait".equals(pathArray[0]))) {
                image = this.getUserPortraitImageResized(image, imageId);
            }
        } else {
            String uuid = GetterUtil.getString((String)parameters.get("uuid"));
            long groupId = GetterUtil.getLong((String)parameters.get("groupId"));
            boolean igSmallImage = GetterUtil.getBoolean((String)parameters.get("igSmallImage"));
            if (Validator.isNotNull((String)uuid) && groupId > 0L) {
                try {
                    FileEntry fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    image = this.convertFileEntry(igSmallImage, fileEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (getDefault && image == null) {
            LOG.warn("Get a default image for {}", (Object)imageId);
            image = this.getDefaultImage(pathArray, imageId);
        }
        return image;
    }

    private long getImageId(Map<String, String> parameters) {
        long imageId = GetterUtil.getLong((String)parameters.get("image_id"));
        if (imageId <= 0L) {
            imageId = GetterUtil.getLong((String)parameters.get("img_id"));
        }
        if (imageId <= 0L) {
            imageId = GetterUtil.getLong((String)parameters.get("i_id"));
        }
        if (imageId <= 0L) {
            long companyId = GetterUtil.getLong((String)parameters.get("companyId"));
            String screenName = GetterUtil.getString((String)parameters.get("screenName"));
            try {
                if (companyId > 0L && Validator.isNotNull((String)screenName)) {
                    User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                    imageId = user.getPortraitId();
                }
            }
            catch (Exception e) {
                LOG.warn("Error getting user portrait id", (Throwable)e);
            }
        }
        return imageId;
    }

    private Image getUserPortraitImageResized(Image image, long imageId) throws LiferayException {
        if (image == null) {
            return null;
        }
        int maxHeight = GetterUtil.getInteger((String)PropsUtil.get((String)"users.image.max.height"));
        int maxWidth = GetterUtil.getInteger((String)PropsUtil.get((String)"users.image.max.width"));
        if (maxHeight > 0 && image.getHeight() > maxHeight || maxWidth > 0 && image.getWidth() > maxWidth) {
            return LiferayAbstractionFactorySupplier.getInstance().getImageTool().updateUserPortrait(image, imageId);
        }
        return image;
    }

    private Image convertFileEntry(boolean smallImage, FileEntry fileEntry) throws Exception {
        Image image = LiferayAbstractionFactorySupplier.getInstance().getImageTool().newImage();
        image.setModifiedDate(fileEntry.getModifiedDate());
        InputStream is = null;
        is = smallImage ? ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileEntry.getFileVersion(), (int)0) : fileEntry.getContentStream();
        byte[] bytes = FileUtil.getBytes((InputStream)is);
        image.setTextObj(bytes);
        image.setType(fileEntry.getExtension());
        return image;
    }

    private Image getDefaultImage(String[] pathArray, long imageId) {
        if (pathArray == null || pathArray.length == 0) {
            return null;
        }
        String p = pathArray[0];
        if ("company_logo".equals(p) || "layout_set_logo".equals(p) || "logo".equals(p)) {
            return LiferayAbstractionFactorySupplier.getInstance().getImageTool().getDefaultCompanyLogo();
        }
        if ("organization_logo".equals(p)) {
            return LiferayAbstractionFactorySupplier.getInstance().getImageTool().getDefaultOrganizationLogo();
        }
        if ("user_female_portrait".equals(p)) {
            return LiferayAbstractionFactorySupplier.getInstance().getImageTool().getDefaultUserFemalePortrait();
        }
        if ("user_male_portrait".equals(p)) {
            return LiferayAbstractionFactorySupplier.getInstance().getImageTool().getDefaultUserMalePortrait();
        }
        if ("user_portrait".equals(p)) {
            return LiferayAbstractionFactorySupplier.getInstance().getImageTool().getDefaultUserMalePortrait();
        }
        return null;
    }

    public String getTempFileId(de.mklinger.qetcher.liferay.abstraction.FileVersion fileVersion) {
        FileVersion liferayFileVersion = ((LiferayFileVersionWrapper)fileVersion).unwrap();
        return DLUtil.getTempFileId((long)liferayFileVersion.getFileEntryId(), (String)liferayFileVersion.getVersion());
    }

    public de.mklinger.qetcher.liferay.abstraction.FileVersion wrapLiferayFileVersion(Object liferayFileVersion) {
        return new LiferayFileVersionWrapper((FileVersion)liferayFileVersion);
    }
}

