/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import de.mklinger.qetcher.client.jackson.core.type.TypeReference;
import de.mklinger.qetcher.client.jackson.databind.ObjectMapper;
import de.mklinger.qetcher.client.maps.Maps;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.liferay.client.impl.QetcherLiferayServiceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QetcherRawMetadataProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherRawMetadataProcessor.class);
    private static final MediaType METADATA_FROM = MediaType.valueOf((String)"application/octet-stream");
    private static final MediaType METADATA_TO = MediaTypes.JSON.withParameter("extractMetadata", "true");

    public Map<String, String> extractMetadata(InputStream inputStream, String referrer) throws PortalException, SystemException {
        Map<String, Object> rawMetadata;
        LOG.info("Getting metadata with referrer '{}'", (Object)referrer);
        try {
            rawMetadata = this.extractRawMetadata(inputStream, referrer);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
        HashMap metadata = Maps.newHashMap((int)rawMetadata.size());
        for (Map.Entry<String, Object> e : rawMetadata.entrySet()) {
            String name = e.getKey();
            Object value = e.getValue();
            if (!(value instanceof String)) continue;
            LOG.debug("Metadata: {} -> '{}'", (Object)name, value);
            metadata.put(name, (String)value);
        }
        return metadata;
    }

    private Map<String, Object> extractRawMetadata(InputStream inputStream, String referrer) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        QetcherLiferayServiceUtil.convert(inputStream, bout, METADATA_FROM, METADATA_TO, referrer);
        return this.parseJson(bout.toByteArray());
    }

    private Map<String, Object> parseJson(byte[] json) throws IOException {
        TypeReference<HashMap<String, Object>> stringMap = new TypeReference<HashMap<String, Object>>(){};
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.readValue(json, (TypeReference)stringMap);
    }
}

