/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.htmlinliner.Cookie;
import de.mklinger.qetcher.htmlinliner.HtmlElementInliner;
import de.mklinger.qetcher.htmlinliner.InternalResource;
import de.mklinger.qetcher.htmlinliner.QetcherHtmlInlineConfiguration;
import de.mklinger.qetcher.liferay.abstraction.DocumentLibraryFileContents;
import de.mklinger.qetcher.liferay.client.impl.abstraction.LiferayAbstractionFactorySupplier;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayHtmlElementInlinerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LiferayHtmlElementInlinerFactory.class);

    private LiferayHtmlElementInlinerFactory() {
    }

    public static HtmlElementInliner newHtmlElementInliner() {
        return new HtmlElementInliner(new QetcherHtmlInlineConfiguration(), LiferayHtmlElementInlinerFactory.newInternalResourceLoader(), LiferayHtmlElementInlinerFactory.newCookieSupplier());
    }

    private static Function<URI, InternalResource> newInternalResourceLoader() {
        return uri -> {
            DocumentLibraryFileContents contents = LiferayAbstractionFactorySupplier.getInstance().getDLTool().getDocumentLibraryFileContents(uri);
            return LiferayHtmlElementInlinerFactory.newInternalResource(contents);
        };
    }

    private static InternalResource newInternalResource(final DocumentLibraryFileContents contents) {
        return new InternalResource(){

            public InputStream getContents() {
                return contents.getContents();
            }

            public String getContentType() {
                return contents.getContentType();
            }

            public void close() throws Exception {
                contents.close();
            }
        };
    }

    private static Supplier<Collection<Cookie>> newCookieSupplier() {
        return () -> {
            HttpServletRequest request = LiferayAbstractionFactorySupplier.getInstance().getPortalTool().getHttpServletRequest();
            if (request == null) {
                LOG.debug("No request available");
                return Collections.emptySet();
            }
            javax.servlet.http.Cookie[] cookies = request.getCookies();
            if (cookies == null || cookies.length == 0) {
                LOG.debug("No cookies");
                return Collections.emptySet();
            }
            return Stream.of(cookies).map(cookie -> LiferayHtmlElementInlinerFactory.newInlinerCookie(cookie)).collect(Collectors.toList());
        };
    }

    private static Cookie newInlinerCookie(final javax.servlet.http.Cookie cookie) {
        return new Cookie(){

            public String getValue() {
                return cookie.getValue();
            }

            public String getName() {
                return cookie.getName();
            }
        };
    }
}

