/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExtensionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileExtensionUtil.class);

    public static String getExtension(FileVersion fileVersion) {
        String mimeTypeString = fileVersion.getMimeType();
        LOG.debug("Original source file mime type: {}", (Object)mimeTypeString);
        LOG.debug("Original source file extension: {}", (Object)fileVersion.getExtension());
        Set extensions = MimeTypesUtil.getExtensions((String)mimeTypeString);
        String sourceExtension = extensions != null && !extensions.isEmpty() ? (String)extensions.iterator().next() : fileVersion.getExtension();
        if (sourceExtension == null || sourceExtension.isEmpty()) {
            LOG.warn("Could not determine source file extension for file entry {}", (Object)fileVersion.getFileEntryId());
            return null;
        }
        return sourceExtension;
    }
}

