package com.liferay.portal.util;

import java.io.File;
import java.io.InputStream;
import java.util.Set;

import com.liferay.portal.kernel.util.MimeTypes;

import de.mklinger.qetcher.liferay.client.impl.QetcherMimeTypesImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class MimeTypesImpl implements MimeTypes {
	private final QetcherMimeTypesImpl qetcherMimeTypes = new QetcherMimeTypesImpl(new LiferayMimeTypesImpl());

	@Override
	public String getContentType(final File file) {
		return qetcherMimeTypes.getContentType(file);
	}

	@Override
	public String getContentType(final File file, final String fileName) {
		return qetcherMimeTypes.getContentType(file, fileName);
	}

	@Override
	public String getContentType(final InputStream inputStream, final String fileName) {
		return qetcherMimeTypes.getContentType(inputStream, fileName);
	}

	@Override
	public String getContentType(final String fileName) {
		return qetcherMimeTypes.getContentType(fileName);
	}

	@Override
	public boolean isWebImage(final String mimeType) {
		return qetcherMimeTypes.isWebImage(mimeType);
	}

	@Override
	public String getExtensionContentType(final String extension) {
		return qetcherMimeTypes.getExtensionContentType(extension);
	}

	@Override
	public Set<String> getExtensions(final String contentType) {
		return qetcherMimeTypes.getExtensions(contentType);
	}
}
