package com.liferay.portlet.documentlibrary.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import com.liferay.portal.kernel.exception.SystemException;

/**
 * This class is intended to be placed as a patch in tomcat/webapps/ROOT/WEB-INF/classes.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class DocumentConversionUtil {
	private DocumentConversionUtil() {
	}

	public static File convert(final String id, final InputStream inputStream, final String sourceExtension, final String targetExtension) throws IOException, SystemException {
		return de.mklinger.qetcher.liferay.client.impl.DocumentConversionUtil.convert(id, inputStream, sourceExtension, targetExtension);
	}

	public static String[] getConversions(final String extension) {
		return de.mklinger.qetcher.liferay.client.impl.DocumentConversionUtil.getConversions(extension);
	}

	public static String getFilePath(final String id, final String targetExtension) {
		return de.mklinger.qetcher.liferay.client.impl.DocumentConversionUtil.getFilePath(id, targetExtension);
	}

	public static boolean isComparableVersion(final String extension) {
		return de.mklinger.qetcher.liferay.client.impl.DocumentConversionUtil.isComparableVersion(extension);
	}

	public static boolean isConvertBeforeCompare(final String extension) {
		return de.mklinger.qetcher.liferay.client.impl.DocumentConversionUtil.isConvertBeforeCompare(extension);
	}

	public static boolean isEnabled() {
		return de.mklinger.qetcher.liferay.client.impl.DocumentConversionUtil.isEnabled();
	}

	public static void disconnect() {
		de.mklinger.qetcher.liferay.client.impl.DocumentConversionUtil.disconnect();
	}
}