package com.liferay.portal.kernel.util;

import java.io.File;
import java.io.InputStream;
import java.util.Set;

import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;

import de.mklinger.qetcher.liferay.client.impl.MimeTypesImpl;

/**
 * This class is intended to be placed as a patch in tomcat/webapps/ROOT/WEB-INF/classes.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class MimeTypesUtil {
	private static final MimeTypesImpl mimeTypes = (MimeTypesImpl) MimeTypesImpl.getInstance();

	/**
	 * Returns the content type from the file.
	 *
	 * @param  file the file of the content
	 * @return the content type if it is a supported format or
	 *         "application/octet-stream" if it is an unsupported format
	 */
	public static String getContentType(final File file) {
		return getMimeTypes().getContentType(file);
	}

	/**
	 * Returns the content type from the file and file name.
	 *
	 * @param  file the file of the content (optionally <code>null</code>)
	 * @param  fileName the full name or extension of the file (e.g.,
	 *         "Test.doc", ".doc")
	 * @return the content type if it is a supported format or
	 *         "application/octet-stream" if it is an unsupported format
	 */
	public static String getContentType(final File file, final String fileName) {
		return getMimeTypes().getContentType(file, fileName);
	}

	/**
	 * Returns the content type from the input stream and file name.
	 *
	 * <p>
	 * The input stream is not reset upon return of this method. This needs to
	 * be handled by the caller if the input stream is to be reused.
	 * Alternatively, use the method {@link #getContentType(File, String)}.
	 * </p>
	 *
	 * @param  inputStream the input stream of the content (optionally
	 *         <code>null</code>)
	 * @param  fileName the full name or extension of the file (e.g.,
	 *         "Test.doc", ".doc")
	 * @return the content type if it is a supported format or
	 *         "application/octet-stream" if it is an unsupported format
	 */
	public static String getContentType(
			final InputStream inputStream, final String fileName) {

		return getMimeTypes().getContentType(inputStream, fileName);
	}

	/**
	 * Returns the content type from the file name.
	 *
	 * @param  fileName the full name or extension of the file (e.g.,
	 *         "Test.doc", ".doc")
	 * @return the content type if it is a supported format or
	 *         "application/octet-stream" if it is an unsupported format
	 */
	public static String getContentType(final String fileName) {
		return getMimeTypes().getContentType(fileName);
	}

	/**
	 * Returns the content type from the file extension.
	 *
	 * @param  extension the extension of the file (e.g., "doc")
	 * @return the content type if it is a supported format or
	 *         "application/octet-stream" if it is an unsupported format
	 */
	public static String getExtensionContentType(final String extension) {
		return getMimeTypes().getExtensionContentType(extension);
	}

	/**
	 * Returns the possible file extensions for the content type.
	 *
	 * @param  contentType the content type of the file (e.g., "image/jpeg")
	 * @return the set of extensions if it is a known content type or an empty
	 *         set if it is an unknown content type
	 */
	public static Set<String> getExtensions(final String contentType) {
		return getMimeTypes().getExtensions(contentType);
	}

	public static MimeTypes getMimeTypes() {
		PortalRuntimePermission.checkGetBeanProperty(MimeTypesUtil.class);

		return mimeTypes;
	}

	public static boolean isWebImage(final String mimeType) {
		return getMimeTypes().isWebImage(mimeType);
	}

	public void setMimeTypes(final MimeTypes mimeTypes) {
		PortalRuntimePermission.checkSetBeanProperty(getClass());

		MimeTypesUtil.mimeTypes.setLiferayMimeTypes(mimeTypes);
	}
}
