package de.mklinger.qetcher.liferay.abstraction;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class DocumentLibraryFileContents implements Closeable {
	private final String fileName;
	private final InputStream contents;
	private final long contentLength;
	private final String contentType;

	public DocumentLibraryFileContents(final String fileName, final InputStream contents, final long contentLength, final String contentType) {
		this.fileName = fileName;
		this.contents = contents;
		this.contentLength = contentLength;
		this.contentType = contentType;
	}

	public String getFileName() {
		return fileName;
	}

	public InputStream getContents() {
		return contents;
	}

	public long getContentLength() {
		return contentLength;
	}

	public String getContentType() {
		return contentType;
	}

	@Override
	public void close() throws IOException {
		if (contents != null) {
			contents.close();
		}
	}
}