package de.mklinger.qetcher.liferay.client.impl;

import java.security.KeyStore;
import java.util.Map;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.Supplier;

import de.mklinger.micro.annotations.VisibleForTesting;
import de.mklinger.micro.keystores.KeyStores;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
@Component(configurationPid = QetcherTrustStoreConfiguration.ID, service = QetcherTrustStoreSupplier.class)
public class QetcherTrustStoreSupplier implements Supplier<KeyStore> {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherTrustStoreSupplier.class);

	private KeyStore trustStore;

	@Activate
	@Modified
	public void activate(final Map<String, Object> properties) {
		LOG.debug("Trust store supplier activated");
		final QetcherTrustStoreConfiguration configuration = ConfigurableUtil.createConfigurable(QetcherTrustStoreConfiguration.class, properties);
		activate(configuration);
	}

	@VisibleForTesting
	protected synchronized void activate(final QetcherTrustStoreConfiguration configuration) {
		trustStore = loadTrustStore(configuration);
	}

	@Deactivate
	protected synchronized void deactivate() {
		trustStore = null;
	}

	@VisibleForTesting
	protected KeyStore loadTrustStore(final QetcherTrustStoreConfiguration configuration) {
		LOG.debug("Loading Qetcher trust store from {}", configuration.trustStoreLocation());

		if ("pem".equalsIgnoreCase(configuration.trustStoreType())) {
			return KeyStores.loadPemCertificates(
					configuration.trustStoreLocation(),
					getClass().getClassLoader());
		} else {
			String actualType;
			if (configuration.trustStoreType() == null || configuration.trustStoreType().isEmpty()) {
				actualType = KeyStore.getDefaultType();
			} else {
				actualType = configuration.trustStoreType();
			}

			return KeyStores.load(
					configuration.trustStoreLocation(),
					configuration.trustStorePassword(),
					actualType,
					getClass().getClassLoader());
		}
	}

	@Override
	public KeyStore get() {
		return trustStore;
	}
}
