/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.htmlinliner;

import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.mediatype.MediaType;
import de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71.LiferayAbstractionFactory;
import de.mklinger.qetcher.liferay.client.impl.htmlinliner.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoaderImpl
implements ResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceLoaderImpl.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @Override
    public Optional<String> getContents(URI url, URI referrer) {
        LOG.info("Fetching {} for inline contents", (Object)url);
        try {
            URLConnection connection = this.get(url, referrer);
            Charset charset = this.getCharset(connection);
            StringWriter sw = new StringWriter();
            WriterOutputStream wout = new WriterOutputStream((Writer)sw, charset);
            try (InputStream in = connection.getInputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)wout);
            }
            wout.flush();
            String contents = sw.toString();
            return Optional.of(contents);
        }
        catch (Exception e) {
            LOG.info("Error getting contents for inlining: {}", (Object)url);
            LOG.debug("Error getting contents for inlining had exception:", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> getExternalInlineImgSrc(URI url, URI referrer) {
        LOG.info("Fetching {} for inline image", (Object)url);
        try {
            URLConnection connection = this.get(url, referrer);
            String contentType = this.getImageContentType(connection);
            try (InputStream in = connection.getInputStream();){
                Optional<String> optional = Optional.of(this.getInlineImgSrc(contentType, in));
                return optional;
            }
        }
        catch (Exception e) {
            LOG.info("Error getting contents for inlining: {}", (Object)url);
            LOG.debug("Error getting contents for inlining had exception:", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public String getInlineImgSrc(String contentType, InputStream in) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)in);
        String base64Data = Base64.getEncoder().encodeToString(data);
        StringBuilder sb = new StringBuilder(base64Data.length() + "data:".length() + contentType.length() + ";base64,".length());
        sb.append("data:");
        sb.append(contentType);
        sb.append(";base64,");
        sb.append(base64Data);
        return sb.toString();
    }

    private URLConnection get(URI uri, URI referrer) throws IOException {
        int statusCode;
        URLConnection connection = uri.toURL().openConnection();
        if (this.isSameHost(uri, referrer)) {
            LOG.debug("Using cookies for url {}", (Object)uri);
            this.setCookies(connection);
        }
        connection.connect();
        if (connection instanceof HttpURLConnection && (statusCode = ((HttpURLConnection)connection).getResponseCode()) != 200) {
            throw new QetcherClientException("Non 200 status code (" + statusCode + ") for content: " + uri);
        }
        return connection;
    }

    private boolean isSameHost(URI uri1, URI uri2) {
        return uri1.getScheme() != null && uri1.getScheme().equals(uri2.getScheme()) && uri1.getHost() != null && uri1.getHost().equals(uri2.getHost()) && uri1.getPort() == uri2.getPort();
    }

    private void setCookies(URLConnection connection) {
        HttpServletRequest request = LiferayAbstractionFactory.getInstance().getPortalTool().getHttpServletRequest();
        if (request == null) {
            LOG.debug("No request available");
            return;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            LOG.debug("No cookies");
            return;
        }
        for (Cookie cookie : cookies) {
            connection.addRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
        }
    }

    private Charset getCharset(URLConnection connection) {
        MediaType mediaType;
        Optional responseCharset;
        String contentType = connection.getContentType();
        if (contentType != null && !contentType.isEmpty() && (responseCharset = (mediaType = MediaType.valueOf((String)contentType)).getParameter("charset")).isPresent()) {
            try {
                Charset charset = Charset.forName((String)responseCharset.get());
                LOG.debug("Using response charset: {}", (Object)charset);
                return charset;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return UTF_8;
    }

    private String getImageContentType(URLConnection connection) {
        String contentType = connection.getContentType();
        if (contentType == null) {
            throw new QetcherClientException("No content type available for inline image");
        }
        MediaType mediaType = MediaType.valueOf((String)contentType);
        if (!"image".equals(mediaType.getType())) {
            throw new QetcherClientException("Unsupported content type for inline image: '" + contentType + "'");
        }
        return mediaType.getFullType();
    }

    @Override
    public void close() {
    }
}

