/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.QetcherClientException;
import de.mklinger.qetcher.client.QetcherRemoteException;
import de.mklinger.qetcher.client.common.concurrent.Delay;
import de.mklinger.qetcher.client.mediatype.MediaType;
import de.mklinger.qetcher.client.mediatype.MediaTypes;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.QetcherService;
import de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71.LiferayAbstractionFactory;
import de.mklinger.qetcher.liferay.client.impl.htmlinliner.HtmlElementInliner;
import de.mklinger.qetcher.liferay.client.impl.htmlinliner.QetcherHtmlInlineConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class QetcherServiceImpl
implements QetcherService {
    private static final int JOB_WAIT_TIMEOUT_MINUTES = 5;
    private static final Logger LOG = LoggerFactory.getLogger(QetcherServiceImpl.class);
    @Reference
    private QetcherClientService clientService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path convertToTempFile(InputStream inputStream, String fromMediaType, String toMediaType) {
        MediaType from = MediaType.valueOf((String)fromMediaType);
        MediaType to = MediaType.valueOf((String)toMediaType);
        InputStream actualInputStream = this.getActualInputStream(inputStream, from);
        InputConversionFile inputFile = this.clientService.inputFileFor(() -> actualInputStream).mediaType(from).build();
        InputJob inputJob = this.clientService.job().fromFile(inputFile).toMediaType(to).build();
        Job job = this.createJobWithTimeout(inputJob).join();
        try {
            Path path = (Path)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getJobDoneWithTimeout(job).thenApply(this::requireSuccess)).thenApply(this::getSingleResultFileId)).thenCompose(arg_0 -> ((QetcherClient)this.clientService.client()).downloadAsTempFile(arg_0))).join();
            return path;
        }
        finally {
            try {
                this.deleteJobWithTimeout(job).join();
            }
            catch (Exception e) {
                LOG.warn("Error deleting job", (Throwable)e);
            }
        }
    }

    private InputStream getActualInputStream(InputStream inputStream, MediaType from) {
        if (MediaTypes.HTML.isCompatible(from)) {
            return this.inlineHtmlElements(inputStream);
        }
        return inputStream;
    }

    private InputStream inlineHtmlElements(InputStream inputStream) {
        byte[] data;
        LOG.info("Inlining HTML elements...");
        String baseUri = LiferayAbstractionFactory.getInstance().getPortalTool().getBaseUrl();
        if (baseUri == null) {
            LOG.warn("Could not get base URL - no HTML inlining can be done");
            return inputStream;
        }
        try (InputStream in = inputStream;
             HtmlElementInliner inliner = new HtmlElementInliner(new QetcherHtmlInlineConfiguration());){
            data = inliner.inline(in, baseUri);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new ByteArrayInputStream(data);
    }

    private CompletableFuture<Job> createJobWithTimeout(InputJob inputJob) {
        return Delay.timeout((CompletableFuture)this.clientService.client().createJob(inputJob), (long)10L, (TimeUnit)TimeUnit.SECONDS, () -> new TimeoutException("Timeout creating job " + inputJob.getInputConversionFile().getFilename() + " " + inputJob.getFromMediaType() + " -> " + inputJob.getToMediaType()));
    }

    private CompletableFuture<Job> getJobDoneWithTimeout(Job job) {
        return Delay.timeout((CompletableFuture)this.clientService.client().getJobDone(job), (long)5L, (TimeUnit)TimeUnit.MINUTES, () -> new TimeoutException("Timeout getting job done " + job.getJobId() + " " + job.getFromMediaType() + " -> " + job.getToMediaType()));
    }

    private Job requireSuccess(Job job) {
        if (job.getState() != JobState.SUCCESS) {
            QetcherRemoteException cause = job.getError() != null ? new QetcherRemoteException(job.getError(), -1) : null;
            throw new QetcherClientException("Job " + job.getJobId() + " is not in state SUCCESS but " + job.getState(), (Throwable)cause);
        }
        return job;
    }

    private String getSingleResultFileId(Job job) {
        List resultFileIds = job.getResultFileIds();
        if (resultFileIds == null || resultFileIds.size() != 1) {
            throw new QetcherClientException("Expected 1 result file but was " + resultFileIds.size());
        }
        return (String)resultFileIds.get(0);
    }

    private CompletableFuture<Void> deleteJobWithTimeout(Job job) {
        return Delay.timeout((CompletableFuture)this.clientService.client().deleteJob(job), (long)30L, (TimeUnit)TimeUnit.SECONDS, () -> new TimeoutException("Timeout deleting job " + job.getJobId() + " " + job.getFromMediaType() + " -> " + job.getToMediaType()));
    }
}

