/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl.abstraction.liferay71;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import de.mklinger.qetcher.liferay.abstraction.PortalTool;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalToolImpl
implements PortalTool {
    private static final Logger LOG = LoggerFactory.getLogger(PortalToolImpl.class);

    public String getBaseUrl() {
        Long companyId;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            String baseUrl = serviceContext.getLayoutFullURL();
            if (baseUrl != null) {
                LOG.debug("Have layout full url: {}", (Object)baseUrl);
                return baseUrl;
            }
            baseUrl = serviceContext.getPortalURL();
            if (baseUrl != null) {
                LOG.debug("Have portal url: {}", (Object)baseUrl);
                return baseUrl;
            }
        }
        if ((companyId = CompanyThreadLocal.getCompanyId()) != null) {
            Company company;
            try {
                company = CompanyLocalServiceUtil.getCompany((long)companyId);
            }
            catch (PortalException | SystemException e) {
                return null;
            }
            String baseUrl = "http://" + company.getVirtualHostname();
            LOG.debug("Have company virtual host url: {}", (Object)baseUrl);
            return baseUrl;
        }
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        return serviceContext.getRequest();
    }
}

