/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.impl;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.QetcherClientBuilders;
import de.mklinger.qetcher.client.common.QetcherException;
import de.mklinger.qetcher.client.httpclient.BodyProviders;
import de.mklinger.qetcher.liferay.client.QetcherClientService;
import de.mklinger.qetcher.liferay.client.common.KeyStores;
import de.mklinger.qetcher.liferay.client.common.VisibleForTesting;
import de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Map;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"de.mklinger.qetcher.liferay.client.impl.QetcherConfiguration"}, immediate=true)
public class QetcherClientServiceImpl
implements QetcherClientService {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherClientServiceImpl.class);
    private QetcherConfiguration configuration;
    private QetcherClient client;

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        this.closeClient();
        this.configuration = (QetcherConfiguration)ConfigurableUtil.createConfigurable(QetcherConfiguration.class, properties);
        try {
            this.client = this.newClient();
            LOG.info("Successfully created new Qetcher client");
        }
        catch (Exception e) {
            LOG.error("Error creating Qetcher client", (Throwable)e);
        }
    }

    @Deactivate
    public void closeClient() {
        if (this.client != null) {
            QetcherClient oldClient = this.client;
            this.client = null;
            oldClient.close();
        }
    }

    private QetcherClient newClient() {
        String[] serviceAddresses = this.configuration.serviceAddresses();
        if (serviceAddresses == null || serviceAddresses.length == 0) {
            throw new QetcherException("No Qetcher service addresses configured", new Object[0]);
        }
        KeyStore keyStore = this.loadKeyStore();
        String keyPassword = this.emptyToNull(this.configuration.keyPassword());
        KeyStore trustStore = this.loadTrustStore();
        return this.newClientBuilder().serviceAddresses(serviceAddresses).keyStore(keyStore, keyPassword).trustStore(trustStore).build();
    }

    @VisibleForTesting
    protected QetcherClient.Builder newClientBuilder() {
        return QetcherClientBuilders.client();
    }

    private KeyStore loadKeyStore() {
        String keyStoreLocation = this.getKeyStoreLocation();
        String keyStorePassword = this.emptyToNull(this.configuration.keyStorePassword());
        String keyStoreType = this.emptyToNull(this.configuration.keyStoreType());
        KeyStore keyStore = KeyStores.load(keyStoreLocation, keyStorePassword, keyStoreType);
        return keyStore;
    }

    private String getKeyStoreLocation() {
        String keyStoreLocation = this.configuration.keyStoreLocation();
        if (keyStoreLocation == null || keyStoreLocation.isEmpty()) {
            keyStoreLocation = PropsUtil.get((String)"liferay.home") + "/data/qetcher/qetcher-key.p12";
            LOG.info("No Qetcher key store location configured. Using default location: {}", (Object)keyStoreLocation);
        }
        return keyStoreLocation;
    }

    @VisibleForTesting
    protected KeyStore loadTrustStore() {
        KeyStore trustStore;
        try {
            trustStore = KeyStores.loadPemCertificates(this.getCaCertLocation(), this.getClass().getClassLoader());
        }
        catch (IOException e) {
            throw new QetcherException("Error loading Qetcher ca certificate", new Object[]{e});
        }
        return trustStore;
    }

    private String getCaCertLocation() {
        return "classpath:" + this.getClass().getPackage().getName().replace('.', '/') + "/mklinger-ca-cert.pem";
    }

    private String emptyToNull(String s) {
        if (s != null && s.trim().isEmpty()) {
            return null;
        }
        return s;
    }

    @Override
    public QetcherClient client() {
        if (this.client == null) {
            throw new QetcherException("Qetcher client is not initialized. Check configuration.", new Object[0]);
        }
        return this.client;
    }

    @Override
    public InputConversionFile.Builder inputFileFor(File inputFile) {
        return QetcherClientBuilders.inputFileFor((File)inputFile);
    }

    @Override
    public InputConversionFile.Builder inputFileFor(Path inputFile) {
        return QetcherClientBuilders.inputFileFor((Path)inputFile);
    }

    @Override
    public InputConversionFile.Builder inputFileFor(Supplier<InputStream> inputStreamSupplier) {
        return QetcherClientBuilders.inputFile().bodyProvider(BodyProviders.fromInputStream(inputStreamSupplier));
    }

    @Override
    public InputJob.Builder job() {
        return QetcherClientBuilders.job();
    }
}

