/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.liferay.client.common;

import de.mklinger.qetcher.client.common.QetcherException;
import de.mklinger.qetcher.client.common.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class KeyStores {
    private static final String CLASSPATH_PREFIX = "classpath:";

    private KeyStores() {
    }

    public static KeyStore load(String location, @Nullable String password) {
        return KeyStores.load(location, password, KeyStore.getDefaultType(), KeyStores.getDefaultClassLoader());
    }

    public static KeyStore load(String location, @Nullable String password, ClassLoader classLoader) {
        return KeyStores.load(location, password, KeyStore.getDefaultType(), classLoader);
    }

    public static KeyStore load(String location, @Nullable String password, String type) {
        return KeyStores.load(location, password, type, KeyStores.getDefaultClassLoader());
    }

    private static ClassLoader getDefaultClassLoader() {
        return KeyStores.class.getClassLoader();
    }

    public static KeyStore load(String location, @Nullable String password, String type, ClassLoader classLoader) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(type);
        Objects.requireNonNull(classLoader);
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            try (InputStream in = KeyStores.newInputStream(location, classLoader);){
                keyStore.load(in, KeyStores.toCharArray(password));
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new QetcherException("Error loading keystore from location '{}'", new Object[]{location, e});
        }
    }

    public static KeyStore loadPemCertificates(String location, ClassLoader classLoader) throws IOException {
        try (InputStream in = KeyStores.newInputStream(location, classLoader);){
            KeyStore keyStore = KeyStores.loadPemCertificates(in);
            return keyStore;
        }
    }

    private static KeyStore loadPemCertificates(InputStream in) throws IOException {
        try {
            return KeyStores.doLoadPemCertificates(in);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            throw new QetcherException("Error loading certificates", new Object[]{e});
        }
    }

    private static KeyStore doLoadPemCertificates(InputStream in) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        InputStream actualIn;
        if (in.markSupported()) {
            actualIn = in;
        } else {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)bout);
            actualIn = new ByteArrayInputStream(bout.toByteArray());
        }
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        CertificateException error = null;
        try {
            Certificate certificate;
            while ((certificate = certFactory.generateCertificate(actualIn)) != null) {
                certificates.add(certificate);
            }
        }
        catch (CertificateException e) {
            if (error == null) {
                error = e;
            }
            error.addSuppressed(e);
        }
        if (certificates.isEmpty()) {
            throw new CertificateException("Unable to load certificates from stream", error);
        }
        return KeyStores.createKeyStoreWith(certificates);
    }

    private static KeyStore createKeyStoreWith(List<Certificate> certificates) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        for (int i = 0; i < certificates.size(); ++i) {
            Certificate c = certificates.get(i);
            keyStore.setCertificateEntry("cert" + i, c);
        }
        return keyStore;
    }

    private static InputStream newInputStream(String location, ClassLoader classLoader) throws IOException {
        if (location.startsWith(CLASSPATH_PREFIX)) {
            String classpathLocation = location.substring(CLASSPATH_PREFIX.length());
            InputStream in = classLoader.getResourceAsStream(classpathLocation);
            if (in == null) {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathLocation);
            }
            if (in == null) {
                throw new FileNotFoundException("Classpath resource not found: " + classpathLocation);
            }
            return in;
        }
        if (location.startsWith("/") || location.startsWith("./")) {
            return new FileInputStream(location);
        }
        return URI.create(location).toURL().openStream();
    }

    private static char[] toCharArray(String password) {
        if (password == null) {
            return null;
        }
        return password.toCharArray();
    }
}

