package de.mklinger.qetcher.liferay.client.impl.htmlinliner;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public interface ResourceLoader extends Closeable {
	/**
	 * Get the contents of the given URL as String.
	 * @return empty optional in case of problems.
	 */
	Optional<String> getContents(URI url, URI referrer);

	/**
	 * Read binary image data from in and get e.g. data:image/jpeg;base64,dada...
	 * @throws IOException In case of encoding problems
	 */
	String getInlineImgSrc(String contentType, InputStream in) throws IOException;

	/**
	 * Get the contents of the given URL as HTML img tag src: e.g. data:image/jpeg;base64,dada...
	 * @return empty optional in case of problems.
	 */
	Optional<String> getExternalInlineImgSrc(URI url, URI referrer);
}
